<?php

defined('BASEPATH') or exit('No direct script access allowed');

class WCS_model extends CI_Model
{

	public $db;
    public $db_name;

    public function __construct()
    {
        parent::__construct();
        $this->db = $this->load->database('default', true);
        $this->db_name = $this->db->database;
    }

    public function update($name_table, $array_data, $array_where)
    {
        $this->db->where($array_where);
        $this->db->update($name_table, $array_data);
    }

    public function delete($name_table, $array_where)
    {
        $this->db->where($array_where);
        $this->db->delete($name_table);
    }

    public function insert($table_name, $array_data)
    {
        $this->db->insert($table_name, $array_data);
    }

    public function get_data($table_name, $array_where = '') //get_all and get_by_id
    {
        if ($array_where) :
            $this->db->where($array_where);
        endif;
        $query = $this->db->get($table_name);
        return $query->result(); //9/9/64 ลบresult()ออก //10/09/64 ลบแล้วของเราพัง
    }

    public function get_join($table_name, $col_name, $array_where = '', $array_table_join = '')
    {

        if ($col_name) :
            $this->db->select($col_name);
        endif;
        if ($array_where) :
            $this->db->where($array_where);
        endif;
        if ($array_table_join) :
            foreach ($array_table_join as $key => $value) :
                $this->db->join($key, $value, 'LEFT'); //ตัวอย่างข้อมูลใน$array_table_join { join => db_personnel.p_id=db_working_experience.w_p_id }
            endforeach;
        endif;

        $query = $this->db->get($table_name);
        return $query;
    }

}