<?php

defined('BASEPATH') OR exit('No direct script access allowed');

require_once dirname(__FILE__) . '/Exhibition_Controller.php';

class Project extends Exhibition_Controller {

    public function show_project_manage()
	{
		$_SESSION['sidebar'] = 'project';
		$this->output_admin('project/v_project_manage');
	}

	public function show_project_manage_user()
	{
		$this->output_user('project/v_project_manage_user');
	}

	public function get_project(){
		$this->load->model('project/M_project','project');
		$data['project'] = $this->project->get_all()->result();
		$data['year'] = $this->project->get_all_year()->result();
		echo json_encode($data);
	}

	public function get_project_user(){
		$id = $_SESSION["user_id"];
		$this->load->model('project/M_project','project');
		$data['project'] = $this->project->get_all_user($id)->result();
		$data['year'] = $this->project->get_all_year_user($id)->result();
		echo json_encode($data);
	}

	public function show_project_create(){
		$this->load->model('cluster/M_cluster','cluster');
		$this->load->model('team/M_team','team');
		$this->load->model('company/M_company','company');
		$this->load->model('tag/M_tag','tag');
		$this->load->model('instructor/M_instructor','instructor');
		$this->load->model('user/M_user','user');
		$data['clusters'] =  $this->cluster->get_all()->result();
		$data['teams'] =  $this->team->get_all()->result();
		$data['companies'] =  $this->company->get_all()->result();
		$data['tags'] =  $this->tag->get_all()->result();
		$data['instructors'] =  $this->instructor->get_all()->result();
		$data['users'] =  $this->user->get_user_project($_SESSION['email'])->result();
		$this->output_admin('project/v_project_create', $data);
	}

	public function show_project_create_user(){
		$this->load->model('cluster/M_cluster','cluster');
		$this->load->model('team/M_team','team');
		$this->load->model('company/M_company','company');
		$this->load->model('tag/M_tag','tag');
		$this->load->model('instructor/M_instructor','instructor');
		$this->load->model('user/M_user','user');
		$data['clusters'] =  $this->cluster->get_all()->result();
		$data['teams'] =  $this->team->get_all()->result();
		$data['companies'] =  $this->company->get_all()->result();
		$data['tags'] =  $this->tag->get_all()->result();
		$data['instructors'] =  $this->instructor->get_all()->result();
		$data['users'] =  $this->user->get_user_project($_SESSION['email'])->result();
		$this->output_user('project/v_project_create_user', $data);
	}

	public function show_project_edit($id){
		$this->load->model('cluster/M_cluster','cluster');
		$this->load->model('team/M_team','team');
		$this->load->model('company/M_company','company');
		$this->load->model('tag/M_tag','tag');
		$this->load->model('instructor/M_instructor','instructor');
		$this->load->model('project/M_project','project');
		$this->load->model('project_tag/M_project_tag','project_tag');
		$data['project'] =  $this->project->get_project_by_id($id)->row();
		$data['clusters'] =  $this->cluster->get_all()->result();
		$data['project_tag'] =  $this->project_tag->get_project_tag_by_id($id)->result();
		$data['teams'] =  $this->team->get_all()->result();
		$data['companies'] =  $this->company->get_all()->result();
		$data['tags'] =  $this->tag->get_all()->result();
		$data['instructors'] =  $this->instructor->get_all()->result();
		$this->output_admin('project/v_project_edit', $data);
	}

	public function show_project_edit_user($id){
		$this->load->model('cluster/M_cluster','cluster');
		$this->load->model('team/M_team','team');
		$this->load->model('company/M_company','company');
		$this->load->model('tag/M_tag','tag');
		$this->load->model('instructor/M_instructor','instructor');
		$this->load->model('project/M_project','project');
		$this->load->model('project_tag/M_project_tag','project_tag');
		$data['project'] =  $this->project->get_project_by_id($id)->row();
		$data['clusters'] =  $this->cluster->get_all()->result();
		$data['project_tag'] =  $this->project_tag->get_project_tag_by_id($id)->result();
		$data['teams'] =  $this->team->get_all()->result();
		$data['companies'] =  $this->company->get_all()->result();
		$data['tags'] =  $this->tag->get_all()->result();
		$data['instructors'] =  $this->instructor->get_all()->result();
		$this->output_user('project/v_project_edit_user', $data);
	}

	public function get_project_detail_member(){
		$id = $this->input->post('id');
		$this->load->model('detail/M_detail','detail');
		$this->load->model('member/M_member','member');
		$this->load->model('user/M_user','user');
		$data['users'] =  $this->user->get_user_project($_SESSION['email'])->result();
		$data['detail'] = $this->detail->get_detail_by_project_id($id)->result();
		$data['member'] = $this->member->get_member_by_project_id($id)->result();
		echo json_encode($data);
	}

	public function change_status(){
		$data['message'] = true ;
		$id = $this->input->post('id');
		$status = $this->input->post('status');
		$this->load->model('project/M_project','project');
		$this->project->change_status($status, $id);
        echo json_encode($data);
	}

	public function insert_project(){
		$data['message'] = true;
		$name = $this->input->post('name');
		$name_en = $this->input->post('name_en');
		$year = $this->input->post('year');
		$graduation = $this->input->post('graduation');
		$company = $this->input->post('company');
		$tags = $this->input->post('tags');
		$select = $this->input->post('select');
		$select_text = $this->input->post('select_text');
		$data_logo = $this->input->post('image_logo');
		$data_cover = $this->input->post('image_cover');
		$details = $this->input->post('detail');
		$members = $this->input->post('member');
		
		$image_logo = 'image_logo_'.date("y-m-d").'.png';
		$image_cover = 'image_cover_'.date("y-m-d").'.png';
		$base64_decode_logo = base64_decode($data_logo);
        $base64_decode_cover = base64_decode($data_cover);
		$this->load->model('project/M_project','project');
		$this->load->model('project_tag/M_project_tag','project_tag');
		$this->load->model('detail/M_detail','detail');
		$this->load->model('member/M_member','member');

		$path_save_image = '';
		if($graduation != 4){
			$path_save_image = getcwd().'/project/year_'.$year.'/y'.$graduation.'/'.$select_text.'/';
			$path = '/project/year_'.$year.'/y'.$graduation.'/'.$select_text.'/';
		}else{
			$path_save_image = getcwd().'/project/year_'.$year.'/y'.$graduation.'/'.$_SESSION['student_id'].'/';
			$path = '/project/year_'.$year.'/y'.$graduation.'/'.$_SESSION['student_id'].'/';
		}
		if(file_exists($path_save_image)){
			$data['message'] = false;
		}
		
		if($data['message'] == true){
			if($graduation == 2){
				$max_id = $this->project->insert_project_cluster($name, $name_en, $year, $company, $select, $path.$image_logo, $path.$image_cover);
			}else if($graduation == 3){
				$max_id = $this->project->insert_project_team($name, $name_en, $year, $company, $select, $path.$image_logo, $path.$image_cover);
			}else{
				$max_id = $this->project->insert_project_instructor($name, $name_en, $year, $company, $select, $path.$image_logo, $path.$image_cover);
			}

			foreach ($tags as $tag){
				$this->project_tag->insert_project_tag($max_id, $tag);
			}

			if(!file_exists(getcwd().'/project/year_'.$year)){
				$folder_project = getcwd().'/project/'; 
				mkdir($folder_project.'year_'.$year);
				$folder_yesr = getcwd().'/project/year_'.$year.'/'; 
				mkdir($folder_yesr.'y'.$graduation);
				$folder_graduation = getcwd().'/project/year_'.$year.'/y'.$graduation.'/'; 
				if($graduation == 2 || $graduation == 3){
					mkdir($folder_graduation.$select_text);
				}else{
					mkdir($folder_graduation.$_SESSION['student_id']);
				}
			}else if(!file_exists(getcwd().'/project/year_'.$year.'/y'.$graduation)){
				$folder_yesr = getcwd().'/project/year_'.$year.'/'; 
				mkdir($folder_yesr.'y'.$graduation);
				$folder_graduation = getcwd().'/project/year_'.$year.'/y'.$graduation.'/'; 
				if($graduation == 2 || $graduation == 3){
					mkdir($folder_graduation.$select_text);
				}else{
					mkdir($folder_graduation.$_SESSION['student_id']);
				}
			}else{
				$folder_graduation = getcwd().'/project/year_'.$year.'/y'.$graduation.'/'; 
				if($graduation == 2 || $graduation == 3){
					mkdir($folder_graduation.$select_text);
				}else{
					mkdir($folder_graduation.$_SESSION['student_id']);
				}
			}

			file_put_contents($path_save_image.$image_logo, $base64_decode_logo); 
			file_put_contents($path_save_image.$image_cover, $base64_decode_cover); 

			if(isset($details)){
				for($i=0;$i<count($details);$i++){
					$data_image1 = $details[$i]['image1'];
					$data_image2 = $details[$i]['image2'];
					$image1 = 'image_detail_1_'.$i.'.png';
					$image2 = 'image_detail_2_'.$i.'.png';
					$description = $details[$i]['textarea'];
					$template = $details[$i]['template'];
					$this->detail->insert_detail($description, $path.$image1, $path.$image2, $template, $max_id);
					if($data_image1){
						$base64_decode_image1 = base64_decode($data_image1);
						file_put_contents($path_save_image.$image1, $base64_decode_image1);
					}
					if($data_image1){
						$base64_decode_image2 = base64_decode($data_image2);
						file_put_contents($path_save_image.$image2, $base64_decode_image2);
					}
				}
			}

			if(isset($members)){
				for($i=0;$i<count($members);$i++){
					$image_member = 'image_1_'.$i.'.png';
					$data_image_member = $members[$i]['value'];
					$select = $members[$i]['select'];
					$this->member->insert_member($path.$image_member, $select, $max_id);
					if($data_image1){
						$base64_decode_image_member = base64_decode($data_image_member);
						file_put_contents($path_save_image.$image_member, $base64_decode_image_member);
					}
				}
			}
		}
		echo json_encode($data);
	}



	public function update_project(){
		$data['message'] = true;
		$id = $this->input->post('id');
		$name = $this->input->post('name');
		$name_en = $this->input->post('name_en');
		$year = $this->input->post('year');
		$graduation = $this->input->post('graduation');
		$company = $this->input->post('company');
		$tags = $this->input->post('tags');
		$select = $this->input->post('select');
		$select_text = $this->input->post('select_text');
		$data_logo = $this->input->post('image_logo');
		$data_cover = $this->input->post('image_cover');
		$details = $this->input->post('detail');
		$members = $this->input->post('member');
		
		$image_logo = 'image_logo_'.date("y-m-d").'.png';
		$image_cover = 'image_cover_'.date("y-m-d").'.png';
		$base64_decode_logo = base64_decode($data_logo);
        $base64_decode_cover = base64_decode($data_cover);
		$this->load->model('project/M_project','project');
		$this->load->model('project_tag/M_project_tag','project_tag');
		$this->load->model('detail/M_detail','detail');
		$this->load->model('member/M_member','member');
		$this->load->model('cluster/M_cluster','cluster');
		$this->load->model('team/M_team','team');
		$this->load->model('instructor/M_instructor','instructor');
		$path_old = '';
		$project = $this->project->get_project_by_id($id)->row();
		if($project->cluster_id != 0){
			$select_old = $this->cluster->get_cluster_by_id($project->cluster_id)->row();
			$path_old = '/project/year_'.$project->date.'/y2/'.$select_old->name.'/';
		}else if($project->team_id != 0){
			$select_old  = $this->team->get_team_by_id($project->team_id)->row();
			$path_old = '/project/year_'.$project->date.'/y3/'.$select_old->name.'/';
		}else{
			$path_old = '/project/year_'.$project->date.'/y4/'.$_SESSION['student_id'].'/';
		}
		
		$path_save_image = '';
		if($graduation != 4){
			$path_save_image = getcwd().'/project/year_'.$year.'/y'.$graduation.'/'.$select_text.'/';
			$path = '/project/year_'.$year.'/y'.$graduation.'/'.$select_text.'/';
		}else{
			$path_save_image = getcwd().'/project/year_'.$year.'/y'.$graduation.'/'.$_SESSION['student_id'].'/';
			$path = '/project/year_'.$year.'/y'.$graduation.'/'.$_SESSION['student_id'].'/';
		}
		$check_path_old = true;
		if($path_old != $path){
			if(file_exists($path_save_image)){
				$data['message'] = false;
			}
		}else{
			$check_path_old = true;
		}

		if($data['message'] == true){
			if($graduation == 2){
				$this->project->update_project_cluster($name, $name_en, $year, $company, $select, $path.$image_logo, $path.$image_cover, $id);
			}else if($graduation == 3){
				$this->project->update_project_team($name, $name_en, $year, $company, $select, $path.$image_logo, $path.$image_cover, $id);
			}else{
				$this->project->update_project_instructor($name, $name_en, $year, $company, $select, $path.$image_logo, $path.$image_cover, $id);
			}
			$this->project_tag->delete_project_tag_by_id($id);
			foreach ($tags as $tag){
				$this->project_tag->insert_project_tag($id, $tag);
			}

			$files = glob(getcwd().$path.'*'); // get all file names
			foreach($files as $file){ // iterate files
				if(is_file($file)) {
					unlink($file); // delete file
				}
			}

			if($check_path_old == true){
				if(!file_exists(getcwd().'/project/year_'.$year)){
					$folder_project = getcwd().'/project/'; 
					mkdir($folder_project.'year_'.$year);
					$folder_yesr = getcwd().'/project/year_'.$year.'/'; 
					mkdir($folder_yesr.'y'.$graduation);
					$folder_graduation = getcwd().'/project/year_'.$year.'/y'.$graduation.'/'; 
					if($graduation == 2 || $graduation == 3){
						mkdir($folder_graduation.$select_text);
					}else{
						mkdir($folder_graduation.$_SESSION['student_id']);
					}
				}else if(!file_exists(getcwd().'/project/year_'.$year.'/y'.$graduation)){
					$folder_yesr = getcwd().'/project/year_'.$year.'/'; 
					mkdir($folder_yesr.'y'.$graduation);
					$folder_graduation = getcwd().'/project/year_'.$year.'/y'.$graduation.'/'; 
					if($graduation == 2 || $graduation == 3){
						mkdir($folder_graduation.$select_text);
					}else{
						mkdir($folder_graduation.$_SESSION['student_id']);
					}
				}else{
					$folder_graduation = getcwd().'/project/year_'.$year.'/y'.$graduation.'/'; 
					if($graduation == 2 || $graduation == 3){
						if(!file_exists($folder_graduation.$select_text)){
							mkdir($folder_graduation.$select_text);
						}
					}else{
						if(!file_exists(getcwd().'/project/year_'.$year.'/y'.$graduation)){
							if(!file_exists($folder_graduation.$_SESSION['student_id'])){
								mkdir($folder_graduation.$_SESSION['student_id']);
							}
						}
					}
				}
			}

			file_put_contents($path_save_image.$image_logo, $base64_decode_logo); 
			file_put_contents($path_save_image.$image_cover, $base64_decode_cover); 

			$this->detail->delete_detail_by_id($id);
			if(isset($details)){
				for($i=0;$i<count($details);$i++){
					$data_image1 = $details[$i]['image1'];
					$data_image2 = $details[$i]['image2'];
					$image1 = 'image_detail_1_'.$i.'.png';
					$image2 = 'image_detail_2_'.$i.'.png';
					$description = $details[$i]['textarea'];
					$template = $details[$i]['template'];
					$this->detail->insert_detail($description, $path.$image1, $path.$image2, $template, $id);
					if($data_image1){
						$base64_decode_image1 = base64_decode($data_image1);
						file_put_contents($path_save_image.$image1, $base64_decode_image1);
					}
					if($data_image1){
						$base64_decode_image2 = base64_decode($data_image2);
						file_put_contents($path_save_image.$image2, $base64_decode_image2);
					}
				}
			}

			$this->member->delete_member_by_id($id);
			if(isset($members)){
				for($i=0;$i<count($members);$i++){
					$image_member = 'image_1_'.$i.'.png';
					$data_image_member = $members[$i]['value'];
					$select = $members[$i]['select'];
					$this->member->insert_member($path.$image_member, $select, $id);
					if($data_image_member){
						$base64_decode_image_member = base64_decode($data_image_member);
						file_put_contents($path_save_image.$image_member, $base64_decode_image_member);
					}
				}
			}

			if($path_old != $path){
				if(file_exists($path_save_image)){
					$files = glob(getcwd().$path_old.'/*'); // get all file names
					foreach($files as $file){ // iterate files
						if(is_file($file)) {
							unlink($file); // delete file
						}
					}
					rmdir(getcwd().$path_old);
				}
			}
		}

		echo json_encode($data);
	}

	function check_folder_exist(){
		$data['message'] = true;
		$year = $this->input->post('year');
		$graduation = $this->input->post('graduation');
		$select_text = $this->input->post('select_text');
		$path_save_image = '';
		if($graduation != 4){
			$path_save_image = getcwd().'/project/year_'.$year.'/y'.$graduation.'/'.$select_text.'/';
		}else{
			$path_save_image = getcwd().'/project/year_'.$year.'/y'.$graduation.'/'.$_SESSION['student_id'].'/';
		}
		if(file_exists($path_save_image)){
			$data['message'] = false;
		}
		echo json_encode($data);
	}
}



