<?php

defined('BASEPATH') OR exit('No direct script access allowed');

require_once dirname(__FILE__) . '/Exhibition_Controller.php';

class Company extends Exhibition_Controller {

    public function show_company_manage()
	{
		$_SESSION['sidebar'] = 'company';
		$this->output_admin('company/v_company_manage');
	}

	public function get_company(){
		$this->load->model('company/M_company','company');
		$data['company'] = $this->company->get_all()->result();
		echo json_encode($data);
	}

	public function delete_company(){
		$data['message'] = true;
		$id = $this->input->post('id');
		$this->load->model('company/M_company','company');
		$this->load->model('project/M_project','project');
		$projects = $this->project->get_all()->result();
		foreach($projects as $project){
			if($project->company_id == $id){
				$data['message'] = false;
			}
		}
		if($data['message'] != false){
			$this->company->delete_company($id);
		}
        echo json_encode($data);
	}

	public function insert_company(){
		$data['message'] = true;
		$name = $this->input->post('name');
		$data_image = $this->input->post('image');
        if($data_image != null){
            $image_array_1 = explode(";", $data_image);
            $image_array_2 = explode(",", $image_array_1[1]);
            $base64_decode = base64_decode($image_array_2[1]);
        }
		$image = 'image_'.date("Y-m-d").'.png';
		$this->load->model('company/M_company','company');
		$companys = $this->company->get_all()->result();
		foreach($companys as $company){
			if(strtoupper($company->name) == strtoupper($name)){
				$data['message'] = false;
			}
		}
		if($data['message'] == true){
			$this->company->insert_company($name, $image);
			$max_id =  $this->company->get_max_id()->row();
			$folder = getcwd().'/image/company/';
			mkdir($folder.'company_'.$max_id->max_id);
			if($data_image != null){
				$path_img = getcwd().'/image/company/company_'.$max_id->max_id.'/image_'.date("Y-m-d").'.png';
				file_put_contents($path_img, $base64_decode); 
			}else{
				$path_image_form = getcwd().'/image/profile_default.png';
				$path_img = getcwd().'/image/company/company_'.$max_id->max_id.'/image_'.date("Y-m-d").'.png';
				copy($path_image_form, $path_img);
			}
		}
		echo json_encode($data);
	}

	public function update_company() 
	{
		$data['message'] = true;
		$id = $this->input->post('id');
		$name = $this->input->post('name');
		$data_image = $this->input->post('image');
		$image = 'image_'.date("Y-m-d").'.png';
		$this->load->model('company/M_company', 'company');
		$companys = $this->company->get_all()->result();
		foreach($companys as $company){
			if(strtoupper($company->name) == strtoupper($name) && $id != $company->company_id){
				$data['message'] = false;
			}
		}
		if($data['message'] == true){
			if($data_image != null || $data_image != ''){
				$this->company->update_company($name, $image, $id);
				//update image
				$image_array_1 = explode(";", $data_image);
				$image_array_2 = explode(",", $image_array_1[1]);
				$base64_decode = base64_decode($image_array_2[1]);
				$files = glob(getcwd().'/image/company/company_'.$id.'/*');
				foreach($files as $file){
					if(is_file($file)) {
						unlink($file);
					}
				}
				$path_img = getcwd().'/image/company/company_'.$id.'/image_'.date("Y-m-d").'.png';
				file_put_contents($path_img, $base64_decode); 
			}else{
				$this->company->update_company_no_image($name, $id);
			}
		}
		echo json_encode($data);
	}




}



