<?php

defined('BASEPATH') OR exit('No direct script access allowed');

require_once dirname(__FILE__) . '/Exhibition_Controller.php';

class User extends Exhibition_Controller {

    public function show_user_manage()
	{
		$_SESSION['sidebar'] = 'user';
		$this->output_admin('user/v_user_manage');
	}

	public function get_user(){
		$this->load->model('user/M_user','user');
		$data['user'] = $this->user->get_all()->result();
		echo json_encode($data);
	}

	public function show_user_create(){
		$this->output_admin('user/v_user_create');
	}

	public function show_user_create_excel(){
		$this->output_admin('user/v_user_create_excel');
	}

	public function show_user_edit($id){
		$this->load->model('user/M_user','user');
		$data['user'] = $this->user->get_user_by_id($id)->row();
		$this->output_admin('user/v_user_edit', $data);
	}

	public function check_email_duplicate(){
		$id = $this->input->post('id');
		$email = $this->input->post('email');
        $data['message'] = true;
		$this->load->model('user/M_user','user');
		$users = $this->user->get_all()->result();
		foreach($users as $user){
			if($email == $user->email && $id != $user->user_id){
				$data['message'] = false;
			}
		}
        echo json_encode($data);
	}

	public function insert_user(){
		$data['message'] = true;
		$first_name = $this->input->post('first_name');
		$last_name = $this->input->post('last_name');
		$student_id = $this->input->post('student_id');
		$email = $this->input->post('email');
		$password = $this->input->post('password');
		$role = $this->input->post('role');
		$this->load->model('user/M_user','user');
		$users = $this->user->get_all()->result();
		foreach($users as $user){
			if($email == $user->email){
				$data['message'] = false;
			}
		}
		if($data['message'] == true){
			$this->user->insert_user($first_name, $last_name, $student_id, $email, $role, $password);
		}
		echo json_encode($data);
	}

	public function update_user(){
		$data['message'] = true;
		$id = $this->input->post('id');
		$first_name = $this->input->post('first_name');
		$last_name = $this->input->post('last_name');
		$student_id = $this->input->post('student_id');
		$email = $this->input->post('email');
		$password = $this->input->post('password');
		$role = $this->input->post('role');
		$this->load->model('user/M_user','user');
		$users = $this->user->get_all()->result();
		foreach($users as $user){
			if(strtoupper($email) == strtoupper($user->email) && $id != $user->user_id){
				$data['message'] = false;
			}
		}
		if($data['message'] == true){
			$password  = '' ? 
			$this->user->update_user_no_pass($first_name, $last_name, $student_id, $email, $role, $id) :
			$this->user->update_user($first_name, $last_name, $student_id, $email, $role, $password, $id);
		}
		echo json_encode($data);
	}


	public function delete_user(){
		$id = $this->input->post('id');
		$this->load->model('user/M_user','user');
		$this->user->delete_user($id);
		$data['message'] = true ;
        echo json_encode($data);
	}

	public function insert_user_excel(){
		$data['message'] = true;
		$data['result'] = array();
		$result = $this->input->post('data');
		$this->load->model('user/M_user','user'); 
		$users = $this->user->get_all()->result();
		for($i=1 ;$i<count($result);$i++){
			foreach($users as $user){
				if($result[$i][4] == $user->email){
					$data['message'] = false;
					array_push($data['result'], $result[$i]);
				}
			}
			if($data['message'] == true){
				$this->user->insert_user_excel($result[$i]);
			}
			$data['message'] = true;
		}
        echo json_encode($data);
	}

}



