<?php

defined('BASEPATH') OR exit('No direct script access allowed');

require_once dirname(__FILE__) . '/Exhibition_Controller.php';

class Instructor extends Exhibition_Controller {

    public function show_instructor_manage()
	{
		$_SESSION['sidebar'] = 'instructor';
		$this->output_admin('instructor/v_instructor_manage');
	}

	public function get_instructor(){
		$this->load->model('instructor/M_instructor','instructor');
		$data['instructor'] = $this->instructor->get_all()->result();
		echo json_encode($data);
	}

	public function delete_instructor(){
		$data['message'] = true ;
		$id = $this->input->post('id');
		$this->load->model('instructor/M_instructor','instructor');
		$this->load->model('project/M_project','project');
		$projects = $this->project->get_all()->result();
		foreach($projects as $project){
			if($project->instructor_id == $id){
				$data['message'] = false;
			}
		}
		if($data['message'] != false){
			$this->instructor->delete_instructor($id);
		}
        echo json_encode($data);
	}

	public function insert_instructor(){
		$data['message'] = true ;
		$name = $this->input->post('name');
		$this->load->model('instructor/M_instructor','instructor');
		$instructors = $this->instructor->get_all()->result();
		foreach($instructors as $instructor){
			if(strtoupper($instructor->name) == strtoupper($name)){
				$data['message'] = false ;
			}
		}
		if($data['message'] == true){ 
			$this->instructor->insert_instructor($name);
		}
        echo json_encode($data);
	}

	public function update_instructor(){
		$data['message'] = true ;
		$id = $this->input->post('id');
		$name = $this->input->post('name');
		$this->load->model('instructor/M_instructor','instructor');
		$instructors = $this->instructor->get_all()->result();
		foreach($instructors as $instructor){
			if(strtoupper($instructor->name) == strtoupper($name) && $id != $instructor->instructor_id){
				$data['message'] = false ;
			}
		}
		if($data['message'] == true){
			$this->instructor->update_instructor($name, $id);
		}
        echo json_encode($data);
	}
}



