<?php

defined('BASEPATH') or exit('No direct script access allowed');

require_once dirname(__FILE__) . '/Exhibition_Controller.php';

class general extends Exhibition_Controller
{

    public function show_general_home()
    {
        $this->load->model('company/M_company', 'company');
        $this->load->model('tag/M_tag', 'tag');
        $this->load->model('team/M_team', 'team');
        $data['teams'] =  $this->team->get_all()->result();
        $data['companies'] =  $this->company->get_all()->result();
        $data['tags'] =  $this->tag->get_all()->result();
        $this->output_general('general/v_general_home', $data);
    }

    public function show_project_2()
    {
        $this->output_general('general/v_project_2');
    }

    public function show_project_3()
    {
        $this->output_general('general/v_project_3');
    }

    public function show_project_4()
    {
        $this->output_general('general/v_project_4');
    }

    public function get_num_project()
    {
        $year = $_GET['year'];
        $this->load->model('general/M_general', 'num_project');
        $data['num_project'] = $this->num_project->get_num_project($year)->row();
        echo json_encode($data);
    }

    public function get_trend()
    {
        $this->load->model('general/M_general', 'trend');
        $data['trend'] = $this->trend->get_trend()->result();
        echo json_encode($data);
    }

    public function get_project_2()
    {
        $year = $_GET['year'];
        $this->load->model('general/M_general', 'project_2');
        $data['project_2'] = $this->project_2->get_project_2($year)->result();
        echo json_encode($data);
    }

    public function get_project_year()
    {
        $this->load->model('general/M_general', 'year');
        $data['year'] = $this->year->get_project_year()->result();
        echo json_encode($data);
    }

    public function get_project_2_year()
    {
        $this->load->model('general/M_general', 'year');
        $data['year'] = $this->year->get_project_2_year()->result();
        echo json_encode($data);
    }

    public function get_project_3()
    {
        $year = $_GET['year'];
        $this->load->model('general/M_general', 'project_3');
        $data['project_3'] = $this->project_3->get_project_3($year)->result();
        echo json_encode($data);
    }

    public function get_project_3_year()
    {
        $this->load->model('general/M_general', 'year');
        $data['year'] = $this->year->get_project_3_year()->result();
        echo json_encode($data);
    }

    public function get_project_4()
    {
        $year = $_GET['year'];
        $this->load->model('general/M_general', 'project_4');
        $data['project_4'] = $this->project_4->get_project_4($year)->result();
        echo json_encode($data);
    }

    public function get_project_4_year()
    {
        $this->load->model('general/M_general', 'year');
        $data['year'] = $this->year->get_project_4_year()->result();
        echo json_encode($data);
    }

    public function get_data_pagination()
    {
        $year = $_GET['year'];
        $page = $_GET['page'];
        $limit = $_GET['limit'];
        $this->load->model('general/M_general', 'pagination');
        $data['pagination'] = $this->pagination->get_data_pagination($year, $page, $limit)->result();
        echo json_encode($data);
    }

    public function get_data_search_pagination()
    {
        $year = $_GET['year'];
        $grade = $_GET['grade'];
        $cluster = $_GET['cluster'];
        $team = $_GET['team'];
        $company = $_GET['company'];
        $pname = $_GET['pname'];
        $tag = $_GET['tag'];
        $page = $_GET['page'];
        $limit = $_GET['limit'];
        // ($tag == '') ?: $tag = implode(',', $tag);
        $this->load->model('general/M_general', 'pagination');
        $data['pagination'] = $this->pagination->get_data_search_pagination($year, $grade, $cluster, $team, $company, $pname, $tag, $page, $limit)->result();
        echo json_encode($data);
    }

    public function get_num_page()
    {
        $year = $_GET['year'];
        $this->load->model('general/M_general', 'num');
        $data['num'] = $this->num->get_num_page($year)->result();
        echo json_encode($data);
    }

    public function get_num_search_page()
    {
        $year = $_GET['year'];
        $grade = $_GET['grade'];
        $cluster = $_GET['cluster'];
        $team = $_GET['team'];
        $company = $_GET['company'];
        $pname = $_GET['pname'];
        $tag = $_GET['tag'];
        ($tag == '') ?: $tag = implode(',', $tag);
        $this->load->model('general/M_general', 'num');
        $data['num'] = $this->num->get_num_search_page($year, $grade, $cluster, $team, $company, $pname, $tag)->result();
        echo json_encode($data);
    }

    public function get_search()
    {
        $year = $this->input->post('year_search');
        if ($year == '') {
            $year = 'YEAR(date)';
        }
        $grade = $this->input->post('grade');
        if ($grade == '2') {
            $grade = 'AND cluster_id != 0';
        } else if ($grade == '3') {
            $grade = 'AND team_id != 0';
        } else if ($grade = 'cluster != 0' == '4') {
            $grade = 'AND cluster_id = 0 AND team_id = 0';
        } else {
            $grade = '';
        }
        $cluster = $this->input->post('cluster');
        if ($cluster == '') {
            $cluster = 'cluster_id';
        }
        $team = $this->input->post('team');
        if ($team == '') {
            $team = 'team_id';
        }
        $company = $this->input->post('company');
        if ($company == '') {
            $company = 'company_id';
        }
        $pname = $this->input->post('pname');
        if ($pname == '') {
            $pname = '';
        } else {
            $pname = 'AND (name_th LIKE "%' . $pname . '%" OR name_en LIKE "%' . $pname . '%")';
        }
        $tag = $this->input->post('tag');
        $data['year'] = $year;
        $data['grade'] = $grade;
        $data['cluster'] = $cluster;
        $data['team'] = $team;
        $data['company'] = $company;
        $data['pname'] = $pname;
        $data['tag'] = $tag;
        $this->output_frontend('general/v_search', $data);
    }

    public function get_search_data()
    {
        $year = $this->input->post('year_search');
        if ($year == '') {
            $year = 'YEAR(date)';
        }
        $grade = $this->input->post('grade');
        if ($grade == '2') {
            $grade = 'AND cluster_id != 0';
        } else if ($grade == '3') {
            $grade = 'AND team_id != 0';
        } else if ($grade = 'cluster != 0' == '4') {
            $grade = 'AND cluster_id = 0 AND team_id = 0';
        } else {
            $grade = '';
        }
        $cluster = $this->input->post('cluster');
        if ($cluster == '') {
            $cluster = 'cluster_id';
        }
        $team = $this->input->post('team');
        if ($team == '') {
            $team = 'team_id';
        }
        $company = $this->input->post('company');
        if ($company == '') {
            $company = 'company_id';
        }
        $pname = $this->input->post('pname');
        if ($pname == '') {
            $pname = 'name';
        }
        $tag = $this->input->post('tag');
        if ($tag == '') {
            $tag = 'project_tag.tag_id';
        }

        $this->load->model('general/M_general', 'search');
        $data['search'] = $this->search->get_search($year, $grade, $cluster, $team, $company, $pname, $tag)->result();
        $data['keyword'] = $this->input->post();
        // echo "<pre>";
        // echo print_r($this->input->post());
        // echo "</pre>";

        $this->load->view('general/v_search', $data);
    }

    public function show_select($id)
    {
        $this->load->model('project/M_project', 'project');
        $this->load->model('project_tag/M_project_tag', 'project_tag');
        $this->load->model('detail/M_detail', 'detail');
        $this->load->model('member/M_member', 'member');
        $this->load->model('cluster/M_cluster', 'cluster');
        $this->load->model('team/M_team', 'team');
        $this->load->model('instructor/M_instructor', 'instructor');
        $data['project'] =  $this->project->get_project_by_id($id)->row();
        $select = '';
        if ($data['project']->cluster_id != 0) {
            $select = $this->cluster->get_cluster_by_id($data['project']->cluster_id)->row();
        } else if ($data['project']->team_id != 0) {
            $select  = $this->team->get_team_by_id($data['project']->team_id)->row();
        } else {
            $select  = $this->instructor->get_by_id($data['project']->instructor_id)->row();
        }
        $data['project']->select = $select->name;
        $data['project_tag'] =  $this->project_tag->get_by_id($id)->result();
        $data['detail'] = $this->detail->get_detail_by_project_id($id)->result();
        $data['member'] = $this->member->get_member_frontend($id)->result();
        // echo '<pre>';
        // print_r($data);
        // echo '</pre>';

        $this->output_frontend('general/v_general_select', $data);
    }

    public function get_comment()
    {
        $id = $this->input->post('id');
        $this->load->model('general/M_general', 'general');
        $data['comment'] = $this->general->get_comment_all($id)->result();
        echo json_encode($data);
    }

    public function insert_comment()
    {
        $sender = $this->input->post('sender');
        $detail = $this->input->post('detail');
        $id = $this->input->post('id');
        $this->load->model('general/M_general', 'general');
        $this->general->insert_comment($sender, $detail, date("Y-m-d"), $id);
        $data['message'] = true;
        echo json_encode($data);
    }
}
