<style>
    a,
    a:hover {
        color: black;
    }

    .content {
        max-width: 1500px;
        max-height: auto;
        margin: auto;
        background: white;
        padding: 10px;
    }

    .notfound {
        text-align: center;
        font-weight: bold;
    }

    .description-block {
        text-align: left;
    }
</style>
<div class="content-wrapper h-100">
    <div class="content-header">
        <div class="container-fluid g-3">
            Home/ <a href="<?php echo site_url() . '/General/show_general_home/' ?>">Dashboard</a> /ค้นหาขั้นสูง
        </div>
    </div>
    <div class="content">
        <div class="mb-3"></div>
        <div class="card-container">
            <div>
                <label for="limit">จำนวนต่อหน้า: </label>
                <select name="limit" id="limit" onchange="load_num_project(), reset_page(), load_data()">
                    <option value="10">10</option>
                    <option value="20">20</option>
                    <option value="50">50</option>
                    <option value="100">100</option>
                </select>
            </div>
            <br><br>
        </div>
        <div id="project" class="row"></div>
        <nav aria-label="Page navigation">
            <ul class="pagination" id="select-page">
            </ul>
        </nav>
    </div>
</div>
<div id="data-container"></div>
<script>
    $(document).ready(function() {
        load_data()
        load_num_project()
    });


    let current_page = 1;

    function load_data() {
        let limit = document.getElementById("limit").value;
        let year = '<?php echo $year; ?>';
        let grade = '<?php echo $grade; ?>';
        let cluster = '<?php echo $cluster; ?>';
        let team = '<?php echo $team; ?>';
        let company = '<?php echo $company; ?>';
        let pname = '<?php echo $pname; ?>';
        let tag = <?php echo json_encode($tag); ?>;
        $.ajax({
            type: "get",
            url: "<?php echo site_url() . '/General/get_data_search_pagination' ?>",
            data: {
                'year': year,
                'grade': grade,
                'cluster': cluster,
                'team': team,
                'company': company,
                'pname': pname,
                'tag': tag,
                'page': current_page,
                'limit': limit
            },
            dataType: "json",
            success: function(data) {
                console.log(data);
                create_project(data.pagination)
            }
        });
    }

    function load_num_project() {
        let limit = document.getElementById("limit").value;
        let year = '<?php echo $year; ?>';
        let grade = '<?php echo $grade; ?>';
        let cluster = '<?php echo $cluster; ?>';
        let team = '<?php echo $team; ?>';
        let company = '<?php echo $company; ?>';
        let pname = '<?php echo $pname; ?>';
        let tag = <?php echo json_encode($tag); ?>;
        $.ajax({
            type: "get",
            url: "<?php echo site_url() . '/General/get_num_search_page' ?>",
            data: {
                'year': year,
                'grade': grade,
                'cluster': cluster,
                'team': team,
                'company': company,
                'pname': pname,
                'tag': tag,
            },
            dataType: "json",
            success: function(data) {
                console.log(data)
                let num = Math.ceil(data.num[0].num_project / limit);
                create_page_select(num);
            }
        });
    }

    function reset_page() {
        current_page = 1;
    }

    function set_page(page) {
        current_page = page;
        console.log('page' + page);
        load_data();
    }

    function previous_page() {
        if (current_page > 1) {
            current_page--;
            console.log('page' + current_page);
            load_data();
            mark_btn('page' + current_page);
        }
    }

    function next_page(maxPage) {
        if (current_page < maxPage) {
            current_page++;
            console.log('page' + current_page);
            load_data();
            mark_btn('page' + current_page);
        }
    }


    function create_project(data) {
        let html = '';
        data.forEach((row, index) => {
            html += `<a href="<?php echo site_url() . '/General/show_select/' ?>` + row.project_id + `" target="_blank" class="col-md-2">`;
            html += `<div class="card card-widget widget-user">`;
            html += `<div class="widget-user-header text-white" style="background: url('<?php echo base_url() ?>` + row.image_cover + `') center center;">`;
            html += `</div>`;
            html += `<div class="widget-user-image">`;
            html += `<img class="img-circle" src="<?php echo base_url() ?>` + row.image_logo + `" alt="User Avatar">`;
            html += `</div>`;
            html += `<div class="card-body">`;
            html += `<h5 class="description-header"><b>` + row.name_th + `</b></h5><br>`;
            html += `<div class="description-block">`;
            // html += `<h5 class="description-header">` + row.first_name + ' ' + row.last_name + `</h5>`;
            // html += `<h5 class="description-header">` + row.student_id + `</h5>`;
            html += `</div>`;
            html += `</div>`;
            html += `</div>`;
            html += `</a>`;
        })
        document.getElementById('project').innerHTML = html;
    }

    function create_page_select(data) {
        let html = '';
        html += `<li><button class="page-link" onclick="previous_page()">ก่อนหน้า</button></li>`;
        for (i = 0; i < data; i++) {
            let page = i + 1;
            html += `<li><button class="page-link" id="page` + page + `" onclick="set_page(` + page + `); mark_btn('page` + page + `');">` + page + `</button></li>`;
        }
        html += `<li><button class="page-link" onclick="next_page(` + data + `)">ถัดไป</button></li>`;
        document.getElementById('select-page').innerHTML = html;
        mark_btn('page' + current_page);
    }

    function mark_btn(btn_page_id) {
        let elements = document.getElementsByClassName("page-link");
        for (let i = 0; i < elements.length; i++) {
            elements[i].style.backgroundColor = "";
            elements[i].style.color = "";
            elements[i].style.border = "";
        }
        let btn_page = document.getElementById(btn_page_id);
        if (btn_page !== null) {
            btn_page.style.backgroundColor = "darkturquoise";
            btn_page.style.color = "white";
            btn_page.style.border = "1px solid gray";
        }

    }
</script>