<?php

defined('BASEPATH') OR exit('No direct script access allowed');

require_once dirname(__FILE__) . '/Exhibition_Controller.php';

class Tag extends Exhibition_Controller {

    public function show_tag_manage()
	{
		$_SESSION['sidebar'] = 'tag';
		$this->output_admin('tag/v_tag_manage');
	}

	public function get_tag(){
		$this->load->model('tag/M_tag','tag');
		$data['tag'] = $this->tag->get_all()->result();
		echo json_encode($data);
	}

	public function delete_tag(){
		$id = $this->input->post('id');
		$this->load->model('tag/M_tag','tag');
		$this->tag->delete_tag($id);
		$data['message'] = true ;
        echo json_encode($data);
	}

	public function insert_tag(){
		$data['message'] = true ;
		$name = $this->input->post('name');
		$this->load->model('tag/M_tag','tag');
		$tags = $this->tag->get_all()->result();
		foreach($tags as $tag){
			if(strtoupper($tag->name) == strtoupper($name)){
				$data['message'] = false ;
			}
		}
		$this->tag->insert_tag($name);
        echo json_encode($data);
	}

	public function update_tag(){
		$data['message'] = true ;
		$id = $this->input->post('id');
		$name = $this->input->post('name');
		$this->load->model('tag/M_tag','tag');
		$tags = $this->tag->get_all()->result();
		foreach($tags as $tag){
			if(strtoupper($tag->name) == strtoupper($name) && $id != $tag->tag_id){
				$data['message'] = false ;
			}
		}
		if($data['message'] == true){
			$this->tag->update_tag($name, $id);
		}
        echo json_encode($data);
	}
	
	public function change_status(){
		$data['message'] = true ;
		$id = $this->input->post('id');
		$status = $this->input->post('status');
		$this->load->model('tag/M_tag','tag');
		$this->tag->change_status($status, $id);
        echo json_encode($data);
	}
}



