<?php
defined('BASEPATH') or exit('No direct script access allowed');

require_once dirname(__FILE__) . '/../Exhibition_Model.php';

class Da_project extends Exhibition_Model
{

	public function __construct()
	{
		parent::__construct();
	}

	public function change_status($status, $id){
		$sql = "UPDATE {$this->db_name}.project
        SET status = ?
        WHERE project_id = ?";
        $this->db->query($sql, [$status, $id]);
	}

	public function insert_project_cluster($name, $name_en, $year, $company, $select, $image_logo, $image_cover){
		$sql = "INSERT INTO {$this->db_name}.project 
		(
            name_th,
            name_en,
			image_logo,
			image_cover,
			date,
			status,
			company_id,
			cluster_id,
			user_id
        )
        VALUES (?,?,?,?,?,?,?,?,?);";
        $this->db->query($sql, [$name, $name_en, $image_logo, $image_cover, $year, 1, $company, $select, $_SESSION['user_id']]);    
		return $this->db->insert_id();    
	}

	public function insert_project_team($name, $name_en, $year, $company, $select, $image_logo, $image_cover){
		$sql = "INSERT INTO {$this->db_name}.project 
		(
			name_th,
			name_en,
			image_logo,
			image_cover,
			date,
			status,
			company_id,
			team_id,
			user_id
        )
        VALUES (?,?,?,?,?,?,?,?,?);";
        $this->db->query($sql, [$name, $name_en, $image_logo, $image_cover, $year, 1, $company, $select, $_SESSION['user_id']]);      
		return $this->db->insert_id(); 
	}

	public function insert_project_instructor($name, $name_en, $year, $company, $select, $image_logo, $image_cover){
		$sql = "INSERT INTO {$this->db_name}.project 
		(
			name_th,
			name_en,
			image_logo,
			image_cover,
			date,
			status,
			company_id,
			instructor_id,
			user_id
        )
        VALUES (?,?,?,?,?,?,?,?,?);";
        $this->db->query($sql, [$name, $name_en, $image_logo, $image_cover, $year, 1, $company, $select, $_SESSION['user_id']]);       
		return $this->db->insert_id(); 
	}

	public function insert_project_instructor_admin($name, $name_en, $year, $company, $select, $image_logo, $image_cover, $user_id){
		$sql = "INSERT INTO {$this->db_name}.project 
		(
			name_th,
			name_en,
			image_logo,
			image_cover,
			date,
			status,
			company_id,
			instructor_id,
			user_id
        )
        VALUES (?,?,?,?,?,?,?,?,?);";
        $this->db->query($sql, [$name, $name_en, $image_logo, $image_cover, $year, 1, $company, $select, $user_id]);       
		return $this->db->insert_id(); 
	}

	public function update_project_cluster($name, $name_en, $year, $company, $select, $image_logo, $image_cover, $id){
		$sql = "UPDATE {$this->db_name}.project
        SET name_th = ?
		,name_en = ?
		,image_logo = ?
		,image_cover = ? 
		,date = ?  
		,company_id = ?
		,cluster_id = ?
		,team_id = 0
		,instructor_id = 0
        WHERE project_id = ?";
    	$this->db->query($sql, [$name, $name_en, $image_logo, $image_cover, $year, $company, $select, $id]);       
	}

	public function update_project_team($name, $name_en, $year, $company, $select, $image_logo, $image_cover, $id){
		$sql = "UPDATE {$this->db_name}.project
        SET name_th = ?
		,name_en = ?
		,image_logo = ?
		,image_cover = ? 
		,date = ?  
		,company_id = ?
		,team_id = ?
		,cluster_id = 0
		,instructor_id = 0
        WHERE project_id = ?";
    	$this->db->query($sql, [$name, $name_en, $image_logo, $image_cover, $year, $company, $select, $id]);       
	}

	public function update_project_instructor($name, $name_en, $year, $company, $select, $image_logo, $image_cover, $id){
		$sql = "UPDATE {$this->db_name}.project
        SET name_th = ?
		,name_en = ?
		,image_logo = ?
		,image_cover = ? 
		,date = ?  
		,company_id = ?
		,cluster_id = 0
		,team_id = 0
		,instructor_id = ?
        WHERE project_id = ?";
    	$this->db->query($sql, [$name, $name_en, $image_logo, $image_cover, $year, $company, $select, $id]);
	}

	public function update_project_instructor_admin($name, $name_en, $year, $company, $select, $image_logo, $image_cover, $user_id, $id){
		$sql = "UPDATE {$this->db_name}.project
        SET name_th = ?
		,name_en = ?
		,image_logo = ?
		,image_cover = ? 
		,date = ?  
		,company_id = ?
		,cluster_id = 0
		,team_id = 0
		,instructor_id = ?
		,user_id = ?
        WHERE project_id = ?";
    	$this->db->query($sql, [$name, $name_en, $image_logo, $image_cover, $year, $company, $select, $user_id, $id]);
	}
}
