<style>
    a,
    a:hover {
        color: black;
    }

    .content {
        max-width: 1500px;
        max-height: auto;
        margin: auto;
        background: white;
        padding: 10px;
    }

    .notfound {
        text-align: center;
        font-weight: bold;
    }

    .description-block {
        text-align: left;
    }
</style>
<?php $y = $_GET['y']; ?>
<div class="content-wrapper h-100">
    <div class="content-header">
        <div class="container-fluid g-3">
            Home/ <a href="<?php echo site_url() . '/General/show_general_home/' ?>">Dashboard</a> /ผลงานกิจกรรมชั้นปีที่ 4
        </div>
    </div>
    <div class="content">
        <div class="mb-3"></div>
        <div class="card-container">
            <div>
                <label for="year">ปี: </label>
                <select name="year" id="year" onchange="load_num_project(), reset_page(), load_data()">
                </select>
            </div>
            <div>
                <label for="limit">จำนวนต่อหน้า: </label>
                <select name="limit" id="limit" onchange="load_num_project(), reset_page(), load_data()">
                    <option value="10">10</option>
                    <option value="20">20</option>
                    <option value="50">50</option>
                    <option value="100">100</option>
                </select>
            </div>
            <br><br>
        </div>
        <div id="project" class="row"></div>
        <nav aria-label="Page navigation">
            <ul class="pagination" id="select-page">
            </ul>
        </nav>
    </div>
</div>
<div id="data-container"></div>
<script>
    $(document).ready(function() {
        get_project_4_year();
    });

    function get_project_4_year() {
        $.ajax({
            type: 'get',
            url: "<?php echo site_url() . '/General/get_project_4_year'; ?>",
            data: {

            },
            dataType: 'json',
            success: function(data) {
                console.log(data)
                create_option_year(data.year)
                if (data.year != '') {
                    load_data();
                    load_num_project();
                } else {
                    let selectList = document.querySelector('#project')
                    document.getElementById('project').innerHTML = "";
                    selectList.setAttribute("class", "notfound")
                    h2 = document.createElement("h2")
                    h2.setAttribute("class", "notfound")
                    const text = document.createTextNode('- ไม่พบข้อมูล -')
                    h2.appendChild(text)
                    selectList.appendChild(h2)
                }

            }
        })
    }

    let current_page = 1;

    function load_data() {
        var year = document.getElementById("year").value;
        var limit = document.getElementById("limit").value;
        $.ajax({
            type: "get",
            url: "<?php echo site_url() . '/General/get_data_pagination' ?>",
            data: {
                'year': year,
                'page': current_page,
                'limit': limit
            },
            dataType: "json",
            success: function(data) {
                create_project(data.pagination)
            }
        });
    }

    function load_num_project() {
        var year = document.getElementById("year").value;
        var limit = document.getElementById("limit").value;
        $.ajax({
            type: "get",
            url: "<?php echo site_url() . '/General/get_num_page' ?>",
            data: {
                'year': year,
            },
            dataType: "json",
            success: function(data) {
                console.log(data)
                let num = Math.ceil(data.num[0].num_project / limit);
                create_page_select(num);
            }
        });
    }

    function reset_page() {
        current_page = 1;
    }

    function set_page(page) {
        current_page = page;
        console.log('page' + page);
        load_data();
    }

    function previous_page() {
        if (current_page > 1) {
            current_page--;
            console.log('page' + current_page);
            load_data();
        }
    }

    function next_page(maxPage) {
        if (current_page < maxPage) {
            current_page++;
            console.log('page' + current_page);
            load_data();
        }
    }

    function create_option_year(data) {
        let selectList = document.querySelector('#year')
        data.forEach((row, index) => {
            option = document.createElement("option")
            option.setAttribute("value", row.year)
            if (row.year == <?php echo $y ?>) {
                option.setAttribute("selected", "selected")
            }
            const number = parseInt(row.year) + 543
            option.text = number
            selectList.appendChild(option)
        })
    }

    function create_project(data) {
        let html = '';
        data.forEach((row, index) => {
            html += `<a href="<?php echo site_url() . '/General/show_project_4' ?>" class="col-md-2">`;
            html += `<div class="card card-widget widget-user">`;
            html += `<div class="widget-user-header text-white" style="background: url('` + row.image_cover + `') center center;">`;
            html += `</div>`;
            html += `<div class="widget-user-image">`;
            html += `<img class="img-circle" src="` + row.image_logo + `" alt="User Avatar">`;
            html += `</div>`;
            html += `<div class="card-body">`;
            html += `<h5 class="description-header"><b>` + row.pj_name + `</b></h5><br>`;
            html += `<div class="description-block">`;
            html += `<h5 class="description-header">` + row.first_name + ' ' + row.last_name + `</h5>`;
            html += `<h5 class="description-header">` + row.student_id + `</h5>`;
            html += `</div>`;
            html += `</div>`;
            html += `</div>`;
            html += `</a>`;
        })
        document.getElementById('project').innerHTML = html;
    }

    function create_page_select(data) {
        let html = '';
        html += `<li><button class="page-link" onclick="previous_page()">ก่อนหน้า</button></li>`;
        for (i = 0; i < data; i++) {
            let page = i + 1;
            console.log('i' + i);
            html += `<li><button class="page-link" onclick="set_page(` + page + `)">` + page + `</button></li>`;
        }
        html += `<li><button class="page-link" onclick="next_page(` + data + `)">ถัดไป</button></li>`;
        document.getElementById('select-page').innerHTML = html;
    }
</script>