<style>
.required label:after {
    color: #e32;
    content: ' *';
    display: inline;
    /* font-weight: bold; */
}
</style>
<!-- Start Content Wrapper. Contains page content -->
<div class="content-wrapper h-100">
    <!-- Start content header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-left">
                        <a class="breadcrumb-item " href='<?php echo site_url().'/User/show_user_manage';?>'>ผู้ใช้งาน</a>
                        <li class="breadcrumb-item active">เพิ่มผู้ใช้งาน</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <!-- End content-header -->
    <div class="content">
        <div class="container-fluid">
            <div class="card card-outline card-primary">
                <div class="card-header">
                    <h1 class="card-title"><b>เพิ่มผู้ใช้งาน</b></h1>
                </div>
                <div class="card-body">
                    <div class="form-body">
                            <div class="row p-t-20 center">
                                <div class="col-md-6 required">
                                    <div class="form-group">
                                        <label class="form-label">ชื่อ </label>
                                        <input type="text" id="firstname" name="firstname" class="form-control"
                                            autocomplete="off">
                                        <div class="invalid-feedback">&nbsp; กรุณาป้อนข้อมูล</div>
                                    </div>
                                </div>
                                <div class="col-md-6 required">
                                    <div class="form-group has-success">
                                        <label class="form-label">นามสกุล </label>
                                        <input type="text" id="lastname" name="lastname" class="form-control" required
                                            autocomplete="off">
                                        <div class="invalid-feedback">&nbsp; กรุณาป้อนข้อมูล</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row center">
                            <div class="col-md-6 required">
                                <div class="form-group has-success">
                                    <label class="form-label">อีเมล </label>
                                    <input type="email" id="email" name="email" class="form-control" required autocomplete="off">
                                    <div class="invalid-feedback email">&nbsp; กรุณาป้อนข้อมูล</div>
                                </div>
                            </div>
                            <div class="col-md-6 required">
							<div class="form-group has-success">
                                    <label class="form-label">รหัสนิสิต </label>
                                    <input type="text" id="student_id" name="student_id" class="form-control" required autocomplete="off" maxlength="8">
                                    <div class="invalid-feedback email">&nbsp;กรุณาป้อนข้อมูล</div>
                                </div>
                            </div>
                        </div>
                        <div class="row center required">
                            <div class="col-md-6">
                                <div class="form-group has-success">
                                    <label class="form-label">รหัสผ่าน </label>
                                    <input type="password" id="password" name="pass" class="form-control" required>
                                    <div class="invalid-feedback password" id='passw'>&nbsp; กรุณาป้อนข้อมูล</div>
                                </div>
                            </div>
                            <div class="col-md-6 required">
                                <div class="form-group has-success">
                                    <div class="form-group has-success">
                                        <label class="form-label">ยืนยันรหัสผ่าน </label>
                                        <input type="password" id="confirm_password" name="confirm_password"
                                            class="form-control" required>
                                        <div class="invalid-feedback confirm_password" id='check_pass'>&nbsp; กรุณาป้อนข้อมูล</div>
                                    </div>
                                </div>
                            </div>
                        </div>
						<div class="row center required">
                        	<div class="col-md-6">
								<div class="form-group has-success">
									<label class="form-label " > บทบาท </label>
									<select id="role" class="form-control">
										<option value="" disabled>กรุณาเลือกบทบาทผู้ใช้</option>
										<option value="1">User</option>
										<option value="2">Admin</option>
									</select>
									<div class="invalid-feedback">&nbsp; กรุณาป้อนข้อมูล</div>
								</div>
							</div>
						</div>
						<br>
                        <button type="button" id="submit" class="btn btn-default float-right" onclick="create_user()" style="color:white">บันทึก</button>
                        <a type="button" class="btn btn-default float-right" style='margin-right:10px; border-color:#A79E9E;' onclick="cancel_create_user()">ยกเลิก</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
<script>

function create_user(){
	document.getElementById("submit").disabled = true;
	const user = {
		first_name : $('#firstname').val().trim(),
		last_name : $('#lastname').val().trim(),
		student_id :  $('#student_id').val().trim(),
		email : $('#email').val().trim(),
		role : $('#role').val().trim(),
		password : $('#password').val().trim(),
		confirm_password : $('#confirm_password').val().trim(),
	}
	const isEmpty = Object.values(user).every(x => x);
	if(!isEmpty){
		$('input').attr('class','form-control is-invalid');
		$('select').attr('class','form-control is-invalid');
		Toast.fire({
			icon: 'error',
			title: 'กรุณาป้อนข้อมูล',
		})
	}else if(user.password != user.confirm_password){
		Toast.fire({
			icon: 'error',
			title: 'กรุณากรอกรหัสผ่านให้ตรงกัน',
		})
	}else{
		Swal.fire({
			title: ' คุณยืนยันที่จะเพิ่มผู้ใช้งานหรือไม่',
			text: "",
			icon: 'question',
			showCancelButton: true,
			confirmButtonColor: '#3177ce',
			cancelButtonColor: ' white ',
			confirmButtonText: 'ใช่',
			cancelButtonText:  '<Font color=black> ไม่ <Font>',
			reverseButtons: true
		}).then((result) => {
			if (result.value) {
				$.ajax({
					type: 'post',
					url: "<?php echo site_url().'/User/insert_user'; ?>",
					data: {
						'first_name': user.first_name,
						'last_name': user.last_name,
						'student_id': user.student_id,
						'email': user.email,
						'password': $.md5(user.password),
						'role': user.role,
					},
					dataType: 'json',
					success: function(data) {
						if (data['message']) {
							Toast.fire({
								icon: 'success',
								title: 'เพิ่มข้อมูลสำเร็จ',
							}).then((result) => {
								window.location.href = '<?php echo site_url().'/User/show_user_manage';?>';
							})
						}else {
							Toast.fire({
								icon: 'error',
								title: "เพิ่มข้อมูลไม่สำเร็จ",
								text: "อีเมลซ้ำกับข้อมูลในระบบ",
							})
						}
					}
				});
			}
		})
		$(".swal2-cancel").css("border", "1px solid #A79E9E");
	}
	document.getElementById("submit").disabled = false;
}

function cancel_create_user() {
	Swal.fire({
		title: ' คุณต้องการยกเลิกหรือไม่',
		text: "",
		icon: 'question',
		showCancelButton: true,
		confirmButtonColor: '#3177ce',
		cancelButtonColor: ' white ',
		confirmButtonText: 'ใช่',
		cancelButtonText:  '<Font color=black> ไม่ <Font>',
		reverseButtons: true
	}).then((result) => {
		if (result.value) {
			window.location.href = '<?php echo site_url().'/User/show_user_manage';?>';
		} 
	})
	$(".swal2-cancel").css("border", "1px solid #A79E9E");
}

$("input").focusout(function(){
	if( $(this).attr('type') != 'radio' && $(this).attr('type') != 'checkbox'){
		str = $(this).val().trim();
		if(str === ''){
			$(this).attr('class','form-control is-invalid');
		}else{
			$(this).removeClass('is-invalid');
		}
	}
});

$("select").focusout(function(){
	str = $(this).val().trim();
	if(str === ''){
		$(this).attr('class','custom-select is-invalid');
	}else{
		$(this).removeClass('is-invalid');
	}
});

$("#password,#confirm_password").focusout(function(){
	password = $('#password').val().trim();
	confirm_password = $('#confirm_password').val().trim();
	if(password != '' && confirm_password != ''){
		if(password != confirm_password){
			$('#password').attr('class','form-control is-invalid');
			$('.password').html('&nbsp; กรุณากรอกรหัสผ่านให้ตรงกัน')   
			$('#confirm_password').attr('class','form-control is-invalid');
			$('.confirm_password').html('&nbsp; กรุณากรอกรหัสผ่านให้ตรงกัน')   
		}else{
			$('#password').removeClass('is-invalid');
			$('#confirm_password').removeClass('is-invalid');
		}
	}else{
		if( $(this).val().trim() ==''){
			if($(this).attr('id') == 'password' ){
				$("#password").attr('class','form-control is-invalid');
				$('.password').html('&nbsp; กรุณาป้อนข้อมูล')  
			}else if(confirm_password == ''){
				$("#confirm_password").attr('class','form-control is-invalid');
				$('.confirm_password').html('&nbsp; กรุณาป้อนข้อมูล')    
			}
		}
	}
});

$("#email").focusout(function(){
	email = $(this).val().trim();
	$.ajax({
		type: 'post',
		url: "<?php echo site_url() . '/User/check_email_duplicate'; ?>",
		data: {
			'email': email,
		},
		dataType: 'json',
		success: function(data) {
			if(email == ''){
				$("#email").attr('class','form-control is-invalid');
				$('.email').html('&nbsp; กรุณาป้อนข้อมูล')    
			}
			else if(data['message'] == true){
				$('#email').removeClass('is-invalid');

			}else{
				$("#email").attr('class','form-control is-invalid');
				$('.email').html('&nbsp; อีเมลซ้ำกับข้อมูลในระบบ')    
			}
		}
	})
});
</script>
