<style>
    a,
    a:hover {
        color: black;
    }

    body {
        background: #f4f4f4;
        background-color: white;
    }

    body {
        /* margin: 3rem; */
        font: 500 100%;
        font-size: 16px;
        line-height: 1.5;
        color: rgb(0, 0, 0);
    }

    @media (max-width: 1024px) {
        body {
            margin: 0;
            background: #f4f4f4;
        }
    }

    @media (max-width: 411px) {
        h5 {
            margin-top: 30px
        }
    }

    .img {
        background-image: url(small.jpg);
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .description {
        font: 500 100%;
        font-size: 16px;
    }

    .card {
        border-radius: 4px;
        background: #fff;
        box-shadow: 0 6px 10px rgba(0, 0, 0, .08), 0 0 6px rgba(0, 0, 0, .05);
        transition: .3s transform cubic-bezier(.155, 1.105, .295, 1.12), .3s box-shadow, .3s -webkit-transform cubic-bezier(.155, 1.105, .295, 1.12);
    }

    .section {
        padding: 40px 0;
    }

    .title {
        padding-top: 0px;
    }

    table,
    th,
    td {
        border-collapse: collapse;
    }

    .test_text {
        overflow: hidden;
        text-overflow: ellipsis;
        display: -webkit-box;
        -webkit-line-clamp: 2;
        line-clamp: 2;
        -webkit-box-orient: vertical;

    }

    span {
        font-size: 14px;
        color: #41474c;
    }

    .footer-bar {
        background-color: white;
        padding: 10px 0px;
    }

    .icon {
        color: #41474c;
    }

    .my-image {
        width: 200px;
        height: 200px;
        object-fit: cover;
        border-radius: 50%;
    }

    .tag-lg {
        font-size: .8em;
        border-radius: 4px;
    }

    .tag-custom {
        background: #ffffff;
        color: #000;
        border-style: solid;
        border-width: 0.7px;
    }

    .tag {
        display: inline-block;
        border-radius: 3px;
        padding: .0em .3em .0em;
        border-radius: 2px;
        font-weight: 400;
        margin: .25em .1em
    }

    .image-detail {
        object-fit: cover;
        width: auto;
        height: auto;
        padding: 20px;
        display: block;
        margin-left: auto;
        margin-right: auto;
    }

    .text-primary-custom {
        color: #007bff !important
    }

    .form-control:focus {
        border: 1px solid #767170;
        box-shadow: none;
        outline: 0 !important;
        color: #2c2c2c;
    }

    .card:hover {
        transform: scale(1.02);
        box-shadow: 0 10px 20px rgba(0, 0, 0, .12), 0 4px 8px rgba(0, 0, 0, .06);
    }
</style>
<?php $tag = (!isset($tag)) ? '' : $tag;
$pname = (!isset($pname)) ? '' : $pname;
$company = (!isset($company)) ? '' : $company;
$cluster = (!isset($cluster)) ? '' : $cluster;
$team = (!isset($team)) ? '' : $team;
$grade = (!isset($grade)) ? '' : $grade;
$year = (!isset($year)) ? '' : $year;
$search = (!isset($search)) ? 'all' : $search;
?>
<div class="wrapper">
    <div class="container-fluid">
        <div class="section section-about-us" style="padding: 0px">
            <div class="content" style="padding: 20px">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-2 position-relative">
                            <label for="limit" class="form-label">จำนวนต่อหน้า</label>
                            <select name="limit" id="limit" class="form-control form-sm" onchange="load_num_project(), reset_page(), load_data()">
                                <option value="10">10</option>
                                <option value="20">20</option>
                                <option value="50">50</option>
                                <option value="100">100</option>
                            </select>
                        </div>
                    </div><br>
                    <div id="project" class="row">
                    </div><br>
                    <nav aria-label="Page navigation">
                        <ul class="pagination" id="select-page">
                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</div>
<footer class="footer footer-default">
    <div class="container">
        <div class="row">
            <div class="col-md-5">
                <b style="font-size:16px;">คณะวิทยาการสารสนเทศ</b> <br>
                <span>169 ถนนลงหาดบางแสน ตำบลแสนสุข</span><br>
                <span>อำเภอเมือง จังหวัดชลบุรี 20131</span>
            </div>
            <div class="col-md-7 ml-auto" style="margin-top: 20px;">
                <i class="fa fa-phone icon"></i> <span>+66 (0)38-103061,+66 (0)38-10309</span> <br>
                <i class="fa fa-envelope icon"></i> <span>Email : pr@informatics.buu.ac.th </span>
            </div>
        </div>
    </div>
    </div>
</footer>
<footer class="footer-bar">
    <div class=" container ">
        <div class="row justify-content-md-center">
            <div class="col-md-12">
                <div style="text-align: left;" data-mce-style="text-align: left;"><span style="font-size: 12px; font-family: Barlow_Regular0, Tahoma; color: rgb(157, 157, 157);" open="" sans="" color:="" rgb="" 157="" data-mce-style="font-size: 16px; font-family: Barlow_Regular0, Tahoma; color: #9d9d9d;">Copyright © 2018-2022 Faculty of Informatics, Burapha University. All rights reserved.</span></div>
            </div>
        </div>
    </div>
</footer>
<script>
    $(document).ready(function() {
        if ('<?php echo $search; ?>' == 'tag') {
            load_data_tag()
            load_num_project_tag()
        } else {
            load_data()
            load_num_project()
        }
    });

    let current_page = 1;

    function load_data() {
        let limit = document.getElementById("limit").value;
        let year = '<?php echo $year; ?>';
        let grade = '<?php echo $grade; ?>';
        let cluster = '<?php echo $cluster; ?>';
        let team = '<?php echo $team; ?>';
        let company = '<?php echo $company; ?>';
        let pname = '<?php echo $pname; ?>';
        let tag = <?php echo json_encode($tag); ?>;
        $.ajax({
            type: "get",
            url: "<?php echo site_url() . '/General/get_data_search_pagination' ?>",
            data: {
                'year': year,
                'grade': grade,
                'cluster': cluster,
                'team': team,
                'company': company,
                'pname': pname,
                'tag': tag,
                'page': current_page,
                'limit': limit
            },
            dataType: "json",
            success: function(data) {
                console.log(data);
                create_project(data.pagination)
            }
        });
    }

    function load_data_tag() {
        let limit = document.getElementById("limit").value;
        let tag = <?php echo json_encode($tag); ?>;
        $.ajax({
            type: "get",
            url: "<?php echo site_url() . '/General/get_data_search_pagination_tag' ?>",
            data: {
                'tag': tag,
                'page': current_page,
                'limit': limit
            },
            dataType: "json",
            success: function(data) {
                console.log(data);
                create_project(data.pagination)
            }
        });
    }

    function load_num_project() {
        let limit = document.getElementById("limit").value;
        let year = '<?php echo $year; ?>';
        let grade = '<?php echo $grade; ?>';
        let cluster = '<?php echo $cluster; ?>';
        let team = '<?php echo $team; ?>';
        let company = '<?php echo $company; ?>';
        let pname = '<?php echo $pname; ?>';
        let tag = <?php echo json_encode($tag); ?>;
        $.ajax({
            type: "get",
            url: "<?php echo site_url() . '/General/get_num_search_page' ?>",
            data: {
                'year': year,
                'grade': grade,
                'cluster': cluster,
                'team': team,
                'company': company,
                'pname': pname,
                'tag': tag,
            },
            dataType: "json",
            success: function(data) {
                console.log(data)
                let num = Math.ceil(data.num[0].num_project / limit);
                create_page_select(num);
            }
        });
    }

    function load_num_project_tag() {
        let limit = document.getElementById("limit").value;
        let tag = <?php echo json_encode($tag); ?>;
        $.ajax({
            type: "get",
            url: "<?php echo site_url() . '/General/get_num_project_by_tag' ?>",
            data: {
                'tag': tag,
            },
            dataType: "json",
            success: function(data) {
                console.log(data)
                let num = Math.ceil(data.num[0].num_project / limit);
                create_page_select(num);
            }
        });
    }

    function reset_page() {
        current_page = 1;
    }

    function set_page(page) {
        current_page = page;
        console.log('page' + page);
        load_data();
    }

    function previous_page() {
        if (current_page > 1) {
            current_page--;
            console.log('page' + current_page);
            load_data();
            mark_btn('page' + current_page);
        }
    }

    function next_page(maxPage) {
        if (current_page < maxPage) {
            current_page++;
            console.log('page' + current_page);
            load_data();
            mark_btn('page' + current_page);
        }
    }

    function create_project(data) {
        let html = '';
        data.forEach((row, index) => {
            html += '<div class="col-md-3 article-loop" >';
            html += `<a href="<?php echo site_url() . '/General/show_select/' ?>${row.project_id}" style="color:black" class="custom-card card-grow">`;
            html += '<div class="card card-grow">';
            html += `<img class="card-img-top" src="<?php echo base_url() ?>${row.image_cover}" height="150px" style="object-fit: cover;" alt="card card-growimage cap">`;
            html += '<div class="card-body">';
            html += `<div><span><b>${row.name_th}</b></span></div>`;
            (row.cluster_id == 0 & row.team_id == 0) ? html += `<span>${row.first_name} ${row.last_name}</span><br>`: html += `<span>บริษัท : ${row.cp_name}</span><br>`;
            (row.cluster_id == 0 & row.team_id == 0) ? html += `<span>อาจารย์ที่ปรึกษา : ${row.is_name}</span><br>`: (row.cluster_id != 0) ? html += `<span>มกุล : ${row.ct_name}</span><br>` : html += `<span>ทีม : ${row.t_name}</span><br>`;
            html += '</div>';
            html += '</div>';
            html += '</a>';
            html += '</div>';
        })
        document.getElementById('project').innerHTML = html;
    }

    function create_page_select(data) {
        let html = '';
        html += `<li><button class="page-link" onclick="previous_page()">ก่อนหน้า</button></li>`;
        for (i = 0; i < data; i++) {
            let page = i + 1;
            html += `<li><button class="page-link" id="page` + page + `" onclick="set_page(` + page + `); mark_btn('page` + page + `');">` + page + `</button></li>`;
        }
        html += `<li><button class="page-link" onclick="next_page(` + data + `)">ถัดไป</button></li>`;
        document.getElementById('select-page').innerHTML = html;
        mark_btn('page' + current_page);
    }

    function mark_btn(btn_page_id) {
        let elements = document.getElementsByClassName("page-link");
        for (let i = 0; i < elements.length; i++) {
            elements[i].style.backgroundColor = "";
            elements[i].style.color = "";
            elements[i].style.border = "";
        }
        let btn_page = document.getElementById(btn_page_id);
        if (btn_page !== null) {
            btn_page.style.backgroundColor = "darkturquoise";
            btn_page.style.color = "white";
            btn_page.style.border = "1px solid gray";
        }

    }
</script>