<script>


function toDecimal(number) {
    const fixedNumber = Number.parseFloat(number).toFixed(2);
    return String(fixedNumber).replace(/\B(?=(\d{3})+(?!\d))/g, ",");
}


function convert_to_datatable(id_name) {
    var datatable = $('#' + id_name).DataTable({
        dom: 'frtlip',
		"pagingType": "full_numbers",
        "lengthMenu": [
            [10, 25, 50, -1],
            [10, 25, 50, "ทั้งหมด"]
        ],
        language: {
            lengthMenu: "แสดง _MENU_ รายการ",
            emptyTable: "ไม่พบข้อมูลในตาราง",
            search: "ค้นหา :_INPUT_",
            //searchPlaceholder: "ค้นหาข้อมูลในตาราง...",
            info: "แสดงหน้าที่ _START_ จาก _PAGES_ หน้า ทั้งหมด _TOTAL_ รายการ",
            infoEmpty: "แสดงหน้าที่ 0 จาก 0 หน้า รายการทั้งหมด 0 รายการ",
            zeroRecords: "ไม่พบข้อมูลที่ค้นหาในตาราง",
            infoFiltered: "",
            paginate: {
                "first": "",
                "last": "",
                "next": "หน้าถัดไป",
                "previous": "ก่อนหน้า"
            },
            "scrollX": true
        },
        //save stage in sessionStorage of browser
        //(sessionStorage ดีกว่า localStorage ตรงที่พอปิด tab หรือปิด browser มันจะหายไปเอง)
        "bStateSave": true,
        "stateDuration": -1, //บังคับใช้ sessionStorage แทน localStorage (ดังนั้นแม้ใช้คำสั่งของ localStorage มันก็ไป save ใน sessionStorage อยู่ดี)
        "fnStateSave": function(oSettings, oData) {
            localStorage.setItem('DataTables_' + window.location.pathname, JSON.stringify(oData));
        },
        "fnStateLoad": function(oSettings) {
            var data = localStorage.getItem('DataTables_' + window.location.pathname);
            return JSON.parse(data);
        },
        aoColumnDefs: [{
                bSortable: false,
                aTargets: [ -1 ]
        }],    
    });
    return datatable;
} //convert_to_datatable

const Toast = Swal.mixin({
    toast: true,
    position: 'bottom-start',
    showConfirmButton: false,
    timer: 1500,
    timerProgressBar: true,
    didOpen: (toast) => {
    toast.addEventListener('mouseenter', Swal.stopTimer)
    toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
})


</script>
