<?php
defined('BASEPATH') or exit('No direct script access allowed');

require_once dirname(__FILE__) . '/../Exhibition_Model.php';

class Da_project extends Exhibition_Model
{

	public function __construct()
	{
		parent::__construct();
	}

	public function change_status($status, $id){
		$sql = "UPDATE {$this->db_name}.project
        SET status = ?
        WHERE project_id = ?";
        $this->db->query($sql, [$status, $id]);
	}

	public function insert_project_cluster($name, $year, $company, $select, $image_logo, $image_cover){
		$sql = "INSERT INTO {$this->db_name}.project 
		(
            name,
			image_logo,
			image_cover,
			date,
			status,
			company_id,
			cluster_id
        )
        VALUES (?,?,?,?,?,?,?);";
        $this->db->query($sql, [$name, $image_logo, $image_cover, $year, 1, $company, $select]);    
		return $this->db->insert_id();    
	}

	public function insert_project_team($name, $year, $company, $select, $image_logo, $image_cover){
		$sql = "INSERT INTO {$this->db_name}.project 
		(
            name,
			image_logo,
			image_cover,
			date,
			status,
			company_id,
			team_id
        )
        VALUES (?,?,?,?,?,?,?);";
        $this->db->query($sql, [$name, $image_logo, $image_cover, $year, 1, $company, $select]);      
		return $this->db->insert_id(); 
	}

	public function insert_project_instructor($name, $year, $company, $select, $image_logo, $image_cover){
		$sql = "INSERT INTO {$this->db_name}.project 
		(
            name,
			image_logo,
			image_cover,
			date,
			status,
			company_id,
			instructor_id
        )
        VALUES (?,?,?,?,?,?,?);";
        $this->db->query($sql, [$name, $image_logo, $image_cover, $year, 1, $company, $select]);       
		return $this->db->insert_id(); 
	}

	public function update_project_cluster($name, $year, $company, $select, $image_logo, $image_cover, $id){
		$sql = "UPDATE {$this->db_name}.project
        SET name = ?
		,image_logo = ?
		,image_cover = ? 
		,date = ?  
		,company_id = ?
		,cluster_id = ?
        WHERE project_id = ?";
    	$this->db->query($sql, [$name, $image_logo, $image_cover, $year, $company, $select, $id]);       
	}

	public function update_project_team($name, $year, $company, $select, $image_logo, $image_cover, $id){
		$sql = "UPDATE {$this->db_name}.project
        SET name = ?
		,image_logo = ?
		,image_cover = ? 
		,date = ?  
		,company_id = ?
		,team_id = ?
        WHERE project_id = ?";
    	$this->db->query($sql, [$name, $image_logo, $image_cover, $year, $company, $select, $id]);       
	}

	public function update_project_instructor($name, $year, $company, $select, $image_logo, $image_cover, $id){
		$sql = "UPDATE {$this->db_name}.project
        SET name = ?
		,image_logo = ?
		,image_cover = ? 
		,date = ?  
		,company_id = ?
		,instructor_id = ?
        WHERE project_id = ?";
    	$this->db->query($sql, [$name, $image_logo, $image_cover, $year, $company, $select, $id]);
	}
}
