
<style>
input[type="search"]:focus {
    outline: none;
}
input[type="search"]{
  border-radius: 3px;
  border: 1px solid #aaa;
  width: 250px;
}

.dataTables_filter {
  float: left !important;
}
.btn-default{
    border: none;
    background: none;
    border-radius: 50%;
}
select#status{
  border:0px;
  outline:0px;
  width: 190px;
  text-align:center;
}
.dataTables_length{
  padding-top: 0.73em;
}
.table-hover tbody tr:hover td {
  background: #F8F8F8;
}
.card-header{
    box-shadow: 0 .125rem .25rem rgba(0,0,0,.075)!important;
}
div.dataTables_wrapper div.dataTables_info{
  margin-left: -13px;
}
div#filler {
    padding-bottom: 0.7em;
}
select#yearfiller{
    display: inline;
    width: 150px;
  }
select#graduationfiller{
    display: inline;
    width: 100px;
}
.dataTables_filter{ 
  display: none; 
}
option { 
  text-align: left; 
}
.required label:after {
    color: #e32;
    content: ' *';
    display: inline;
    /* font-weight: bold; */
}
</style>
<div class="content-wrapper h-100">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="card card-outline card-primary">
                <div class="card-header">
                    <h1 class="card-title"><b>Project</b></h1>
                </div>
                <div class="card-body">
				<a type="button" href="<?php echo site_url() . "/project/show_project_create"; ?>"  id="submit" class="btn btn=info float-right" style="color:white"><i class="fas fa-plus"></i> Add Project</a>
				<div id="filler">Search: <input id="myInput" type="search" onsearch="OnSearch()" size="4">
					&nbsp;&nbsp;Year:
					<select id="yearfiller" onchange="year_filter()" class="form-control">
						<option value="">All</option>
					</select>
					&nbsp;&nbsp;Graduation:
					<select id="graduationfiller" onchange="graduation_filter()" class="form-control">
						<option value="">All</option>
						<option value="2">2</option>
						<option value="3">3</option>
						<option value="4">4</option>
					</select>
				</div>
					<table class="table table-bordered table-hover" id="myTable">
    					<thead>
    						<tr>
								<th width="5%">No.</th>
								<th style="text-align: left"; >Project Name</th>
								<th style="text-align: left"; width="20%">Year</th>
								<th style="text-align: left"; width="20%">Graduation</th>
    							<th width="15%">Actions</th>
    						</tr>
    					</thead>
    					<tbody id="mybody">
							
						</tbody>
					</table>
                </div>
            </div>
        </div>
    </div>
</div>
<template id="project_template">
	<td class="text-center index"></td>
	<td class="name" style="padding-left:19px"></td>
	<td class="year" style="padding-left:19px"></td>
	<td class="graduation" style="padding-left:19px"></td>
	<td  class="text-center">
		<button type="button" title="Edit" class="btn btn-default edit"><i class="fas fa-edit"></i></button>
		<button type="button" title="Delete" class="btn btn-default delete"><i class="fas fa-trash-alt"></i></button>
	</td>
</template>

<script>
$(document).ready(function() {
	get_project()
});

function get_project() {
    $.ajax({
        type: 'get',
        url: "<?php echo site_url() . '/Project/get_project_user'; ?>",
        dataType: 'json',
        success: function(data) {
			create_option_year(data.year)
			create_table(data.project);
		}
    })
}

function create_table(data) {
	$('#myTable').DataTable().destroy();;
	const table = document.querySelector("#myTable tbody")
    table.innerHTML = ''
	const template = document.getElementById("project_template");
    data.forEach((row, index) => {
		const tr = document.createElement("tr")
		const template_clone = template.content.cloneNode(true);
		template_clone.querySelector('.index').innerText = index+1
		template_clone.querySelector('.name').innerText = row.name;
		template_clone.querySelector('.year').innerText = row.date;
		let graduation 
		if(row.cluster_id != null){
			graduation = 2
		}else if(row.team_id != null){
			graduation = 3
		}else{
			graduation = 4
		}
		template_clone.querySelector('.graduation').innerText =  graduation
		template_clone.querySelector('.edit').addEventListener('click', function(){ window.location.href = '<?php echo site_url().'/project/show_project_edit/';?>'+row.project_id })
		template_clone.querySelector('.delete').addEventListener('click', function(){ delete_project(row.project_id) })
		tr.appendChild(template_clone);
		table.appendChild(tr);
    });
	convert_to_datatable('myTable')
	$(".dataTables_length").css('clear', 'none');
	$(".dataTables_length").css('margin-right', '20px');
	$(".dataTables_info").css('clear', 'none');
	$(".dataTables_info").css('padding-top', '1');
}

function create_option_year(data){
	let selectList = document.querySelector('#yearfiller')
	data.forEach((row, index) => {
		option = document.createElement("option")
		option.setAttribute("value", row.date)
		option.text = row.date
		selectList.appendChild(option)
	})
}

function year_filter(){
	//Get a reference to the new datatable
	var table = $('#myTable').DataTable();
	
	var categoryIndex = 0;
	$("#myTable th").each(function (i) {
	if ($($(this)).html() == "Year") {
		categoryIndex = i; return false;
	}
	});
	//Use the built in datatables API to filter the existing rows by the Category column
	$.fn.dataTable.ext.search.push(
	function (settings, data, dataIndex) {
		var selectedItem = $('#yearfiller').val()
		var text = data[categoryIndex];
		var category = text;
		if (selectedItem === "" || category.includes(selectedItem)) {
		return true;
		}
		return false;
	}
	);
	
	$("#statusfiller").change(function (e) {
	table.draw();
	});
	table.draw();
}

function graduation_filter(){
	//Get a reference to the new datatable
	var table = $('#myTable').DataTable();
	var categoryIndex = 0;
	$("#myTable th").each(function (i) {
	if ($($(this)).html() == "Graduation") {
		categoryIndex = i; return false;
	}
	});
	//Use the built in datatables API to filter the existing rows by the Category column
	$.fn.dataTable.ext.search.push(
	function (settings, data, dataIndex) {
		var selectedItem = $('#graduationfiller').val()
		var text = data[categoryIndex].substring(0, 1);
		if(text == '2'){
			text = '2';
		}else if(text == '3'){
			text = '3';
		}else if(text == '4'){
			text = '4';
		}
		var category = text;

		if (selectedItem === "" || category.includes(selectedItem)) {
		return true;
		}
		return false;
	}
	);
	
	$("#statusfiller").change(function (e) {
	table.draw();
	});
	table.draw();
}

function OnSearch(){
	oTable = $('#myTable').DataTable();  
	oTable.search('').draw(); 
}

function delete_project(id) {
    Swal.fire({
        title: ' Do you want to delete this project?',
        text: "",
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#3177ce',
        cancelButtonColor: ' white ',
        confirmButtonText: 'Yes',
        cancelButtonText:  '<Font color=black> No <Font>',
        reverseButtons: true
    }).then((result) => {
        //Start delete project
        if (result.value) {
            $.ajax({
                type: 'post',
                url: "<?php echo site_url().'/project/delete_project'; ?>",
                data: {
                    'id': id
                },
                dataType: 'json',
                success: async function(data) {
                    if (data['message'] == true) {
                        Toast.fire({
                            icon: 'success',
                            title: 'Delete project success',
                        });
                        await get_project();
                    } 
                    else {
                        Toast.fire({
                            icon: 'success',
                            title: 'Delete project success',
                        });
                    } 
                }
            });
        }
    })
    $(".swal2-cancel").css("border", "1px solid #A79E9E");
}

convert_to_datatable('myTable')
$(".dataTables_length").css('clear', 'none');
$(".dataTables_length").css('margin-right', '20px');
$(".dataTables_info").css('clear', 'none');
$(".dataTables_info").css('padding-top', '1');
</script>


