<?php
defined('BASEPATH') or exit('No direct script access allowed');

require_once dirname(__FILE__) . '/../Exhibition_Model.php';

class Da_user extends Exhibition_Model
{

	public function __construct()
	{
		parent::__construct();
	}

	public function insert_user($first_name, $last_name, $student_id, $email, $role, $password)
	{
		$sql = "INSERT INTO {$this->db_name}.user 
		(
            first_name,
			last_name,
			student_id,
			email,
			role,
			password,
			is_delete
        )
        VALUES (?,?,?,?,?,?,?);";
        $this->db->query($sql, [$first_name, $last_name, $student_id, $email, $role, $password, 0]);       
	}

	public function delete_user($id)
	{
		$sql = "UPDATE {$this->db_name}.user
        SET is_delete = ?
        WHERE user_id = ?";
        $this->db->query($sql, [1, $id]);
	}

	public function update_user($first_name, $last_name, $student_id, $email, $role, $password, $id)
	{
		$sql = "UPDATE {$this->db_name}.user
        SET first_name = ? , last_name = ? , student_id = ? , email = ? , role = ? , password = ?
        WHERE user_id = ?";
        $this->db->query($sql, [$first_name, $last_name, $student_id, $email, $role, $password, $id]);
	}

	public function update_user_no_pass($first_name, $last_name, $student_id, $email, $role, $id)
	{
		$sql = "UPDATE {$this->db_name}.user
        SET first_name = ? , last_name = ? , student_id = ? , email = ? , role = ?
        WHERE user_id = ?";
        $this->db->query($sql, [$first_name, $last_name, $student_id, $email, $role, $id]);
	}

	public function insert_user_excel($data)
	{
		$sql = "INSERT INTO {$this->db_name}.user 
		(
			student_id,
			prefix,
            first_name,
			last_name,
			email,
			role,
			is_delete
        )
        VALUES (?,?,?,?,?,?,?);";
			$this->db->query($sql, [$data[0], $data[1], $data[2], $data[3], $data[4], 1, 0]);
	}
}
