<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;


class Member extends Model
{
    use HasFactory;

    protected $table = 'Member';
    protected $primaryKey = 'id';
    public $incrementing = true;
    public $timestamps = false;
    protected $fillable = [
        'mem_id_card',
        'mem_prefix_th',
        'mem_prefix_en',
        'mem_fname_th',
        'mem_fname_en',
        'mem_lname_th',
        'mem_lname_en',
        'mem_birthday',
        'mem_lawyer_type',
        'mem_license',
        'mem_lawyer_affiliation',
        'mem_lawyer_relation',
        'mem_email',
        'mem_phone_nember',
        'mem_type',
        'mem_status',
        'mem_balance'
    ];

    public function login_auth($id_card, $pass){

        $user = DB::table('Member')->select('id', 'mem_id_card','mem_type', 'mem_fname_th', 'mem_lname_th', 'mem_status') // Query ข้อมูลจาก Database
        ->where('mem_id_card', $id_card)->where('password', $pass)->first();


        return $user;
    }

    public function insert_new_member(){
        DB::statement('INSERT INTO MEMBER(mem_id_card,mem_prefix_th, mem_prefix_en,mem_fname_th, mem_fname_en, mem_lname_th, mem_lname_en, mem_birthday, mem_lawyer_type, mem_license, mem_lawyer_affiliation, mem_lawyer_relation, mem_email, mem_phone_number, mem_balance, `password`, address_id) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)' , 
             [$this->mem_id_card, $this->mem_prefix_th, $this->mem_prefix_en, $this->mem_fname_th, $this->mem_fname_en, $this->mem_lname_th, $this->mem_lname_en, $this->mem_birthday, $this->mem_lawyer_type,$this->mem_license, $this->mem_lawyer_affiliation, $this->mem_lawyer_relation, $this->mem_email, $this->mem_phone_number, $this->mem_balance, $this->password, $this->address_id ]  );
    }

    public function get_all_user(){
        $user = DB::table('Member')->select()->get();
        return $user;
    }

    public function get_member_detail($id) {
        return DB::table('Member')->join('Address', 'Member.address_id', '=', 'Address.id')->where('Member.id', '=', $id)->get();
    }

    public function approve_member($id) {
        DB::statement('UPDATE Member SET mem_status = 1 WHERE id = ?', [$id]);
    }

    public function reject_member($id) {
        DB::statement('UPDATE Member SET mem_status = 2 WHERE id = ?', [$id]);
    }
}
