<!-- 
    *v_approve_member.blade.php
    *Display approve member table for admin
    *@input : mem_status
    *@output : 
 -->
@extends('layouts.v_navbar_admin')
@section('navbar_admin')
<!DOCTYPE html>

<html>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.3/jquery.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
    integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous" />
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"
    integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous">
</script>
<html lang="en">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css"
    integrity="sha512-jRcyS0JzoOe9Mq3OEn5Q+U67/l7o+f+B2dG1mVWmHJ+ud7M9XmFmB7GJj6o4b4Yl+SGoSyKkfcf1FbzN1Sd9zA=="
    crossorigin="anonymous" referrerpolicy="no-referrer" />
<!-- Boxicons CSS -->
<link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>


<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Approve_member</title>

</head>

<body>

    <div class="display-5 mt-5 ms-5" style="color: #36618D">
        <img src="icon/approve_member/approve.png" width="3%">
        อนุมัติ
    </div>

    <div class="container">
        <div class="row">
            <div class="col mt-5">

                <div class="d-flex flex-row d-flex justify-content-between mt-4 ">
                    <div class="border-bottom border-gray">

                        <span class="col-3 text-center mt-2 ">
                            ทั้งหมด
                        </span>
                        <!-- <span class="col-3 text-center mt-2">
                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;อนุมัติแล้ว
                        </span>
                        <span class="col-3 text-center mt-2">
                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;รออนุมัติ&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        </span> -->

                    </div>
                    <!-- <div class="col-mt-3 d-flex flex-row">
                        <div class="input-group ">
                            <div class="form-outline">
                                <input type="search" id="form1" class="form-control" placeholder="ค้นหา">
                            </div>
                            <button type="button" class="btn btn-primary">
                                <i class='bx bx-search-alt-2'></i>
                            </button>
                        </div>
                    </div> -->
                </div>

                <div class="row bg-white mt-3">
                    <div class=" mt-4 bg-white ">

                        <table id="example" class="table" style="width:100%">
                            <thead>
                                <tr>
                                    <th class="ps-5">วันที่สมัคร</th>
                                    <th>ชื่อ-นามสกุล</th>
                                    <th>ประเภท</th>

                                    <th>
                                        <div width="20px"> <span class="d-flex justify-content-start ms-5"><img
                                                    src="icon/evidence/succeed.png" width="20px"> &nbsp;
                                                อนุมัติแล้ว</span>
                                        </div>
                                        <div width="20px"> <span class="d-flex justify-content-start ms-5"><img
                                                    src="icon/evidence/failed.png" width="20px"> &nbsp;
                                                ปฏิเสธ</span>
                                        </div>
                                        <div width="20px"> <span class="d-flex justify-content-start ms-5"><img
                                                    src="icon/all_user/clock.png" width="20px"> &nbsp;
                                                รออนุมัติ</span>
                                        </div>
                                    </th>
                                    <th></th>
                                </tr>
                            </thead>

                            <tbody>
                                @foreach($user_all as $user)
                                <tr>
                                    <td class="ps-5">01/01/2566</td>
                                    <td>{{$user->mem_prefix_th . " " . $user->mem_fname_th . " " . $user->mem_lname_th}}</td>
                                    <td>{{$user->mem_lawyer_type}}</td>

                                    <?php 
                                        $status = 0;
                                        // if ($status == 0) {
                                        //     $status = 0;
                                        //     echo "Member has been approved!";
                                        // } else if ($status = 1) {
                                        //     echo "Member has already been approved.";
                                        // }
                                    ?>

                                    
                                    @if($user->mem_status == 1)         
                                    <td>
                                        <div width="20px"> <span class="d-flex justify-content-start ms-5"><img
                                                    src="icon/evidence/succeed.png" width="30px"> </span></div>
                                    </td>
                                    @elseif($user->mem_status == 2)
                                    <td>
                                        <div width="20px"> <span class="d-flex justify-content-start ms-5"><img
                                                    src="icon/evidence/failed.png" width="30px"> </span></div>
                                    </td>
                                    @else
                                    <td>
                                        <div width="20px"> <span class="d-flex justify-content-start ms-5"><img
                                                    src="icon/all_user/clock.png" width="30px"></span></div>
                                    </td>
                                    @endif

                                    @if ($user->mem_status == 0)
                                    <td >
                                        <div width="20px"> <span class=""><img
                                                    src="icon/approve_member/three-dots.png" data-bs-toggle="modal"
                                                    data-bs-target="#exampleModal_2" data-toggle="modal"
                                                    width="20px"
                                                    onclick="getMemberDetail(<?php echo $user->id?>)"></span></div>
                                    </td>
                                    @else
                                    <td></td>
                                    @endif
                                </tr>
                                @endforeach
                            </tbody>

                        </table>
                        <!-- <div class="d-grid gap-2 d-md-flex justify-content-md-end m-3">
                            <button class="btn btn-light" type="button">ก่อนหน้า</button>
                            <button class="btn btn-primary" type="button">1</button>
                            <button class="btn btn-light" type="button">2</button>
                            <button class="btn btn-light" type="button">3</button>
                            <button class="btn btn-light" type="button">4</button>
                            <button class="btn btn-light" type="button">5</button>
                            <button class="btn btn-light" type="button">ถัดไป</button>
                        </div> -->
                    </div>
                </div>
            </div>

        </div>
    </div>
    </div>

    <div class="modal fade" id="exampleModal_2" tabindex="-1" aria-labelledby="exampleModalCenterTitle"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content " style="width: 1000px">
                <div class="modal-body needs-validation ">
                    <div class="display-6 mt-5 ms-5" id="topic">
                        กำลังโหลดข้อมูล</div>
                    <div class="row m-4">


                        <div></div>
                        <div class="col-2">คำนำหน้า
                            <input class="form-control" type="text" id="mem_prefix_th" disabled>
                        </div>
                        <div class="col-4">ชื่อ
                            <input class="form-control" type="text" id="mem_fname_th"
                                disabled>
                        </div>
                        <div class="col-4">นามสกุล
                            <input class="form-control" type="text" id="mem_lname_th"
                                disabled>
                        </div>
                        <div class="col-2">อายุ
                            <input class="form-control" type="text" id="mem_age"
                                disabled>
                        </div>
                        <div class="col-6">วันเกิด
                            <input class="form-control" type="text" id="mem_birthday" disabled>
                        </div>
                        <div class="col-6">เลขบัตรประชาชน
                            <input class="form-control" type="text" id="mem_id_card" disabled>
                        </div>
                        <div class="col-6">เบอร์โทรศัพท์
                            <input class="form-control" type="text" id="mem_phone_number" disabled>
                        </div>
                        <div class="col-6">อีเมล
                            <input class="form-control" type="text" id="mem_email" disabled>
                        </div>
                        <div class="col-6">ที่อยู่ตามบัตรประชาชน
                            <input class="form-control" type="text" id="add_house_number" disabled>
                        </div>
                        <div class="col-6">ตำบล/แขวง
                            <input class="form-control" type="text" id="add_sub_district" disabled>
                        </div>
                        <div class="col-6">อำเภอ
                            <input class="form-control" type="text" id="add_district" disabled>
                        </div>

                        <div class="col-6">จังหวัด
                            <input class="form-control" type="text" id="add_province" disabled>
                        </div>
                        <div class="col-4">อนุมัติครั้งที่
                            <input class="form-control" type="text" placeholder="xxxxxxxxxxxx"
                                aria-label="xxxxxxxxxxxx" disabled>
                        </div>
                        <div class="col-4">อนุมัติวันที่
                            <input class="form-control" type="text" placeholder="xxxxxxxxxxxx"
                                aria-label="xxxxxxxxxxxx" disabled>
                        </div>
                        <div class="text-end" id="button-action">
                            <div class="modal fade" id="exampleModalToggle" aria-hidden="true"
                                aria-labelledby="exampleModalToggleLabel" tabindex="-1">
                            </div>
                            <button class="btn btn-primary" data-bs-toggle="modal" role="button" id="approve_btn"
                                onclick="Approve_member()">อนุมัติ</button>
                            <button class="btn btn-danger" data-bs-toggle="modal" role="button" id="reject_btn"
                                onclick="Reject_member()">ปฏิเสธ</button>

                        </div>
                    </div>

                </div>

            </div>

        </div>
    </div>
    </div>

    </div>

    </div>
    </div>



</body>
<script>
    $(document).ready(function () {
        $('table').DataTable();
    });

    let selected_mem_id;
    function getMemberDetail(mem_id) {
        clear_modal();
        selected_mem_id = mem_id;
        $.ajax({
            method:'POST',
            url:'/Get_member_ajax',
            data:{
                'mem_id': mem_id,
                '_token': '<?php echo csrf_token() ?>'
            },
            dataType: "JSON",
            success:function(data) {
                console.log(data);
                render_modal(data);
            }, error: function() {
                console.log("error");
            }
        });

    }

    function clear_modal() {
        $("#topic").html("กำลังโหลดข้อมูล");
        $("#mem_prefix_th").val("");
        $("#mem_fname_th").val("");
        $("#mem_lname_th").val("");
        $("#mem_birthday").val("");
        $("#mem_id_card").val("");
        $("#mem_phone_number").val("");
        $("#mem_email").val("");
        $("#add_house_number").val("");
        $("#add_sub_district").val("");
        $("#add_district").val("");
        $("#add_province").val("");
        $("#approve_btn").attr('disabled', true);
        $("#reject_btn").attr('disabled', true);
    }   

    function render_modal(data) {
        $("#topic").html("ข้อมูลเพิ่มเติม");
        $("#mem_prefix_th").val(data["mem_prefix_th"]);
        $("#mem_fname_th").val(data["mem_fname_th"]);
        $("#mem_lname_th").val(data["mem_lname_th"]);
        $("#mem_birthday").val(data["mem_birthday"]);
        $("#mem_id_card").val(data["mem_id_card"]);
        $("#mem_phone_number").val(data["mem_phone_number"]);
        $("#mem_email").val(data["mem_email"]);
        $("#add_house_number").val(data["add_house_number"]);
        $("#add_sub_district").val(data["add_sub_district"]);
        $("#add_district").val(data["add_district"]);
        $("#add_province").val(data["add_province"]);
        $("#approve_btn").attr('disabled', false);
        $("#reject_btn").attr('disabled', false);
    }

    function Approve_member() {
        $.ajax({
            method:'POST',
            url:'/Approve_member_ajax',
            data:{
                'mem_id': selected_mem_id,
                '_token': '<?php echo csrf_token() ?>'
            },
            dataType: "JSON",
            success:function(data) {
                console.log(data);
                Success();
            }, error: function() {
                console.log("error");
            }
        });
    }

    function Reject_member() {
        $.ajax({
            method:'POST',
            url:'/Reject_member_ajax',
            data:{
                'mem_id': selected_mem_id,
                '_token': '<?php echo csrf_token() ?>'
            },
            dataType: "JSON",
            success:function(data) {
                console.log(data);
                Error();
            }, error: function() {
                console.log("error");
            }
        });
    }


    function Success() {
        Swal.fire({
            position: 'center',
            icon: 'success',
            title: 'อนุมัติสำเร็จ',
            showConfirmButton: false,
            timer: 1500
        })
        location.reload();
    }

    function Error() {
        Swal.fire({
            position: 'center',
            icon: 'error',
            title: 'ปฏิเสธ',
            showConfirmButton: false,
            timer: 1500
        })
        location.reload();
    }
</script>




</html>
@endsection
