<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'is_admin',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    // public function insert_member($mem_prefix_th, $mem_firstname_th, $mem_lastname_th, $mem_prefix_en, $mem_firstname_en, $mem_lastname_en, $mem_id_card, $mem_birthday, $mem_address, $mem_sub_district, $mem_district, $mem_province, $mem_postlcode, $mem_email, $mem_confirm_email, $mem_phone_number){
    //     $sql = "INSERT INTO Member
    //     VALUES(null,'$mem_prefix_th','$mem_firstname_th','$mem_lastname_th', '$mem_prefix_en', '$mem_firstname_en', '$mem_lastname_en', '$mem_id_card', '$mem_birthday', '$mem_address', '$mem_sub_district', '$mem_district', '$mem_province', '$mem_postlcode', '$mem_email', '$mem_confirm_email', '$mem_phone_number')";
    //     $this->db->query($sql);
    // }

}
