<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('Member', function (Blueprint $table){
            $table->id();
            $table->string('mem_id_card')->nullable();
            $table->string('mem_prefix_th')->nullable();
            $table->string('mem_prefix_en')->nullable();
            $table->string('mem_fname_th')->nullable();
            $table->string('mem_fname_en')->nullable();
            $table->string('mem_lname_th')->nullable();
            $table->string('mem_lname_en')->nullable();
            $table->date('mem_birthday')->nullable();
            $table->string('mem_lawyer_type')->nullable();
            $table->string('mem_license')->nullable();
            $table->string('mem_lawyer_affiliation')->nullable();
            $table->string('mem_lawyer_relation')->nullable();
            $table->string('mem_email')->unique()->nullable();
            $table->string('mem_phone_number', 10)->nullable();
            $table->integer('mem_type')->default(1)->nullable();
            $table->integer('mem_status')->default(0);
            $table->integer('mem_balance')->nullable();
            $table->string('password')->nullable();
            $table->string('address_id')->nullable();
            $table->timestamps();
        });


        //mem_status 0=รออนุมัติ
        //           1=อนุมัติ
        //           2=ปฏิเสธ
        //mem_type  0=admin
        //           1=user
        DB::table('Member')->insert([
            [
                'mem_id_card' => '1234577981234',
                'mem_prefix_th' => 'นาย',
                'mem_prefix_en' => 'Mr.',
                'mem_fname_th' => 'บอลซัน',
                'mem_fname_en' => 'Ballsun',
                'mem_lname_th' => 'แฮคกี้',
                'mem_lname_en' => 'hakky',
                'mem_lawyer_type' => '1',
                'mem_type' => '0',
                'mem_status' => '1',
                'mem_birthday' => '2023-5-1',
                'mem_license' => 'aaa',
                'mem_lawyer_affiliation' => 'aaaa',
                'mem_lawyer_relation' => 'aaa',
                'mem_email' => 'admin@ivsoft.com',
                'mem_phone_number' => '09999999',
                'password' => 'admin',
                'address_id' => '1'

            ],
            [
                'mem_id_card' => '1234577991234',
                'mem_prefix_th' => 'นาย',
                'mem_prefix_en' => 'Mr.',
                'mem_fname_th' => 'ซันบอล',
                'mem_fname_en' => 'sunball',
                'mem_lname_th' => 'แฮคกี้',
                'mem_lname_en' => 'hakky',
                'mem_lawyer_type' => '1',
                'mem_type' => '1',
                'mem_status' => '1',
                'mem_birthday' => '2023-5-1',
                'mem_license' => 'aaa',
                'mem_lawyer_affiliation' => 'aaaa',
                'mem_lawyer_relation' => 'aaa',
                'mem_email' => 'user@ivsoft.com',
                'mem_phone_number' => '09999999',
                'password' => 'user',
                'address_id' => '2'

            ],
            [
                'mem_id_card' => '1234578011234',
                'mem_prefix_th' => 'นาย',
                'mem_prefix_en' => 'Mr.',
                'mem_fname_th' => 'แฮคกี้',
                'mem_fname_en' => 'Hakky',
                'mem_lname_th' => 'ซันบอล',
                'mem_lname_en' => 'sunball',
                'mem_lawyer_type' => '1',
                'mem_type' => '1',
                'mem_status' => '0',
                'mem_birthday' => '2023-5-1',
                'mem_license' => 'aaa',
                'mem_lawyer_affiliation' => 'aaaa',
                'mem_lawyer_relation' => 'aaa',
                'mem_email' => 'user_1@ivsoft.com',
                'mem_phone_number' => '09999999',
                'password' => 'user',
                'address_id' => '3'
            ],
            [
                'mem_id_card' => '1234578001234',
                'mem_prefix_th' => 'นาย',
                'mem_prefix_en' => 'Mr.',
                'mem_fname_th' => 'แฮคกี้',
                'mem_fname_en' => 'Hakky',
                'mem_lname_th' => 'บอลซัน',
                'mem_lname_en' => 'ballsun',
                'mem_lawyer_type' => '1',
                'mem_type' => '1',
                'mem_status' => '0',
                'mem_birthday' => '2023-5-1',
                'mem_license' => 'aaa',
                'mem_lawyer_affiliation' => 'aaaa',
                'mem_lawyer_relation' => 'aaa',
                'mem_email' => 'user_2@ivsoft.com',
                'mem_phone_number' => '09999999',
                'password' => 'user',
                'address_id' => '4'

            ],

        ]);
    }



    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('Member');
    }
};
