<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;


return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('Receipt', function (Blueprint $table){
            $table->id();
            $table->string('rec_name')->nullable();
            $table->integer('rec_amount')->nullable();
            $table->date('rec_date')->nullable();
            $table->time('rec_time')->nullable();
            $table->string('rec_img')->nullable();
            $table->integer('rec_status')->nullable();
            $table->integer('mem_id')->nullable();
        });
        //rec_status 0=รออนุมัติ
        //           1=อนุมัติ
        //           2=ปฏิเสธ
        DB::table('Receipt')->insert([
                [
                    'rec_name' =>'บอลซัน แฮคกี้',
                    'rec_amount'=>'500',
                    'rec_date'=>'2023-04-09',
                    'rec_time'=>'15:00:00',
                    'rec_img'=>'2.png',
                    'rec_status'=>'0'
                ],
                [
                    'rec_name' =>'บอลซัน แฮคกี้',
                    'rec_amount'=>'500',
                    'rec_date'=>'2023-04-08',
                    'rec_time'=>'15:00:00',
                    'rec_img'=>'1.png',
                    'rec_status'=>'0'
                ],
            ]);
        }


    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
};
