<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('Member', function (Blueprint $table){
            $table->id();
            $table->string('mem_id_card');
            $table->string('mem_prefix_th');
            $table->string('mem_prefix_en');
            $table->string('mem_fname_th');
            $table->string('mem_fname_en');
            $table->string('mem_lname_th');
            $table->string('mem_lname_en');
            $table->date('mem_birthday');
            $table->string('mem_lawyer_type');
            $table->string('mem_license');
            $table->string('mem_lawyer_affiliation');
            $table->string('mem_lawyer_relation');
            $table->string('mem_email')->unique();
            $table->string('mem_phone_number', 10);
            $table->integer('mem_type')->default(0);
            $table->integer('mem_status')->default(0);
            $table->integer('mem_balance')->nullable();
            $table->string('password')->nullable(false);
            $table->string('address_id');
        });

        DB::table('Member')->insert(
            array(
                'mem_id_card' => '123456789',
                'mem_prefix_th' => 'นาย',
                'mem_prefix_en' => 'Mr.',
                'mem_prefix_th' => 'นาย',
                'mem_fname_th' => 'แอดมิน',
                'mem_fname_en' => 'admin',
                'mem_lname_th' => 'admin',
                'mem_lname_en' => 'admin',
                'mem_lawyer_type' => '1',
                'mem_birthday' => '2023-5-1',
                'mem_license' => 'aaa',
                'mem_lawyer_affiliation' => 'aaaa',
                'mem_lawyer_relation' => 'aaa',
                'mem_email' => 'admin@ivsoft.com',
                'mem_phone_number' => '09999999',
                'password' => 'admin',
                'address_id' => '1'

            )
        );

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('Member');
    }
};
