// ./models/bookingModel.js
const db = require('../app').db; // สมมติว่า app.js export db (เช่น mysql.createPool หรือ connection)

module.exports = {
    // ดึงรายการบริการทั้งหมดจากตาราง services
    getAllServices: () => {
        return new Promise((resolve, reject) => {
            const sql = 'SELECT * FROM services';
            db.query(sql, (err, results) => {
                if (err) {
                    return reject(err);
                }
                resolve(results);
            });
        });
    },
    
    // ดึง booking slots ตามวันที่จากตาราง booking_slots
    getBookingSlotsByDate: (date) => {
        return new Promise((resolve, reject) => {
            const sql = 'SELECT * FROM booking_slots WHERE date = ?';
            db.query(sql, [date], (err, results) => {
                if (err) {
                    return reject(err);
                }
                resolve(results);
            });
        });
    },
    // ค้นหา slot ตามวันที่และเวลา
    getBookingSlotByDateAndTime: (date, time) => {
        return new Promise((resolve, reject) => {
            const sql = 'SELECT * FROM booking_slots WHERE date = ? AND start_time = ?';
            db.query(sql, [date, time], (err, results) => {
                if (err) return reject(err);
                if (results.length === 0) return reject(new Error('ไม่พบ slot ที่เลือก'));
                resolve(results[0]);
            });
        });
    },
    // สร้าง appointment ใหม่
    createAppointment: (data) => {
      return new Promise((resolve, reject) => {
          if (!data.service_id) {
              return reject(new Error(`❌ service_id เป็น NULL ตอนสร้าง appointment!`));
          }
  
          const sql = 'INSERT INTO appointments (user_id, service_id, booking_slot_id, appointment_status, note) VALUES (?,?,?,?,?)';
          db.query(sql, [data.user_id, data.service_id, data.booking_slot_id, data.appointment_status, data.note], (err, result) => {
              if (err) return reject(err);
              resolve(result.insertId);
          });
      });
  },
  
    // อัปเดตสถานะของ booking slot (is_available = 0)
    updateBookingSlot: (booking_slot_id) => {
        return new Promise((resolve, reject) => {
            const sql = 'UPDATE booking_slots SET is_available = 0 WHERE booking_slot_id = ?';
            db.query(sql, [booking_slot_id], (err, result) => {
                if (err) return reject(err);
                resolve(result);
            });
        });
    },
    // สร้าง payment record ใหม่
    createPayment: (appointment_id) => {
        return new Promise((resolve, reject) => {
            const sql = 'INSERT INTO payments (appointment_id, payment_status) VALUES (?, ?)';
            db.query(sql, [appointment_id, 'Pending'], (err, result) => {
                if (err) return reject(err);
                resolve(result);
            });
        });
    },
        // ฟังก์ชันเพิ่มเติมสำหรับหน้า bookingSummary
    getAppointmentById: (appointmentId) => {
      return new Promise((resolve, reject) => {
        const sql = 'SELECT * FROM appointments WHERE appointment_id = ?';
        db.query(sql, [appointmentId], (err, results) => {
          if (err) return reject(err);
          if (results.length === 0) return reject(new Error('ไม่พบการจอง'));
          resolve(results[0]);
        });
      });
    },

    getUserById: (user_id) => {
      return new Promise((resolve, reject) => {
        const sql = 'SELECT * FROM users WHERE user_id = ?';
        db.query(sql, [user_id], (err, results) => {
          if (err) return reject(err);
          if (results.length === 0) return reject(new Error('ไม่พบข้อมูลผู้ใช้'));
          resolve(results[0]);
        });
      });
    },

    getServiceById: (service_id) => {
      return new Promise((resolve, reject) => {
          const sql = 'SELECT * FROM services WHERE service_id = ?';
          db.query(sql, [service_id], (err, results) => {
              if (err) return reject(err);
              if (results.length === 0) {
                  return reject(new Error(`ไม่พบข้อมูลบริการสำหรับ service_id: ${service_id}`)); // Customize message if not found
              }
              resolve(results[0]);
          });
      });
  },
  
    getBookingSlotById: (booking_slot_id) => {
      return new Promise((resolve, reject) => {
        const sql = 'SELECT * FROM booking_slots WHERE booking_slot_id = ?';
        db.query(sql, [booking_slot_id], (err, results) => {
          if (err) return reject(err);
          if (results.length === 0) return reject(new Error('ไม่พบข้อมูล slot'));
          resolve(results[0]);
        });
      });
    },
    // ฟังก์ชันเพิ่มเติมสำหรับหน้า bookingSummary
    getAppointmentById: (appointmentId) => {
        return new Promise((resolve, reject) => {
          const sql = 'SELECT * FROM appointments WHERE appointment_id = ?';
          db.query(sql, [appointmentId], (err, results) => {
            if (err) return reject(err);
            if (results.length === 0) return reject(new Error('ไม่พบการจอง'));
            resolve(results[0]);
          });
        });
      },
  
    getUserById: (user_id) => {
        return new Promise((resolve, reject) => {
          const sql = 'SELECT * FROM users WHERE user_id = ?';
          db.query(sql, [user_id], (err, results) => {
            if (err) return reject(err);
            if (results.length === 0) return reject(new Error('ไม่พบข้อมูลผู้ใช้'));
            resolve(results[0]);
          });
        });
      },
  
    getServiceById: (service_id) => {
        return new Promise((resolve, reject) => {
          const sql = 'SELECT * FROM services WHERE service_id = ?';
          db.query(sql, [service_id], (err, results) => {
            if (err) return reject(err);
            if (results.length === 0) return reject(new Error('ไม่พบข้อมูลบริการ'));
            resolve(results[0]);
          });
        });
      },
  
    getBookingSlotById: (booking_slot_id) => {
        return new Promise((resolve, reject) => {
          const sql = 'SELECT * FROM booking_slots WHERE booking_slot_id = ?';
          db.query(sql, [booking_slot_id], (err, results) => {
            if (err) return reject(err);
            if (results.length === 0) return reject(new Error('ไม่พบข้อมูล slot'));
            resolve(results[0]);
          });
        });
      },
    // เพิ่มฟังก์ชันเพื่อดึง appointments ตามสถานะ
    getAppointmentsByStatus: (user_id, status) => {
      return new Promise((resolve, reject) => {
          const sql = 'SELECT * FROM appointments WHERE user_id = ? AND appointment_status = ?';
          db.query(sql, [user_id, status], (err, results) => {
              if (err) return reject(err);
              resolve(results);  // ส่งกลับการจองที่ตรงกับสถานะ
          });
      });
  },  
  // เพิ่มฟังก์ชันสำหรับการค้นหาบริการตามชื่อหรือคำค้น
    searchServices: (searchTerm) => {
      return new Promise((resolve, reject) => {
          const sql = 'SELECT * FROM services WHERE service_name LIKE ?';
          db.query(sql, [`%${searchTerm}%`], (err, results) => {
              if (err) return reject(err);
              resolve(results);
          });
      });
  },
  // ฟังก์ชันในการดึงข้อมูลการจองจาก appointment_history ตามสถานะ
  getAppointmentsFromHistory: (user_id, status) => {
    return new Promise((resolve, reject) => {
        const sql = 'SELECT * FROM appointment_history WHERE user_id = ? AND appointment_status = ?';
        db.query(sql, [user_id, status], (err, results) => {
            if (err) return reject(err);
            resolve(results);  // ส่งข้อมูลการจองจาก history ที่ตรงกับสถานะ
        });
    });
  },

  getPaymentStatusByAppointmentId: (appointmentId) => {
        return new Promise((resolve, reject) => {
            const sql = 'SELECT payment_status FROM payments WHERE appointment_id = ?';
            db.query(sql, [appointmentId], (err, results) => {
                if (err) return reject(err);
                if (results.length === 0) return reject(new Error('ไม่พบข้อมูลการชำระเงินสำหรับ appointment นี้'));
                resolve(results[0].payment_status); // ส่งกลับสถานะการชำระเงิน
            });
        });
    },

  addToHistory: (appointmentId) => {
      return new Promise((resolve, reject) => {

          const selectSql = `
              SELECT a.appointment_id, a.user_id, a.service_id, a.note, 
                     p.payment_status 
              FROM appointments a 
              LEFT JOIN payments p ON a.appointment_id = p.appointment_id
              WHERE a.appointment_id = ?
          `;
          db.query(selectSql, [appointmentId], (err, results) => {
              if (err) return reject(err);
              if (results.length === 0) return reject(new Error('ไม่พบการจอง'));
  
              const appointment = results[0];

              const insertSql = `
                  INSERT INTO appointment_history 
                  (appointment_id, user_id, service_id, payment_status, note, appointment_status) 
                  VALUES (?, ?, ?, ?, ?, ?)
              `;
              db.query(insertSql, [
                  appointment.appointment_id,
                  appointment.user_id,
                  appointment.service_id,
                  appointment.payment_status || 'Pending',
                  appointment.note,
                  'Cancelled'
              ], (err, result) => {
                  if (err) return reject(err);
  
                  // ลบข้อมูลออกจาก appointments หลังย้ายสำเร็จ
                  const deleteSql = 'DELETE FROM appointments WHERE appointment_id = ?';
                  db.query(deleteSql, [appointmentId], (err, result) => {
                      if (err) return reject(err);
                      resolve(result);
                  });
              });
          });
      });
  },
  
  

};
