const db = require('../app').db;

module.exports = {
  // ฟังก์ชันในการดึงข้อมูล user โดยใช้ email
  getUserByEmail: (email, callback) => {
    db.query('SELECT * FROM Users WHERE email = ?', [email], (err, result) => {
      if (err) return callback(err);
      callback(null, result);
    });
  },

  // ฟังก์ชันในการเพิ่ม user ใหม่ (สำหรับ register)
  createUser: (first_name, last_name, phone, email, hashedPassword, callback) => {
    db.query('INSERT INTO users (first_name, last_name, phone, email, password) VALUES (?, ?, ?, ?, ?)', 
    [first_name, last_name, phone, email, hashedPassword], 
    (err, result) => {
      if (err) return callback(err);
      callback(null, result);
    });
  }  
};
