const mysql = require("mysql2/promise")

// Create connection pool
const pool = mysql.createPool({
  host: process.env.DB_HOST1 ,
  user: process.env.DB_USER1 ,
  password: process.env.DB_PASSWORD1 ,
  database: process.env.DB_NAME1 ,
  waitForConnections: true,
  connectionLimit: 10,
  queueLimit: 0,
})

// Test connection
async function testConnection() {
  try {
    const connection = await pool.getConnection()
    console.log("Connected to database")
    connection.release()
  } catch (err) {
    console.error("Database connection error: " + err.stack)
  }
}

testConnection()

module.exports = pool

