const db = require("../config/db")

class Test {
  static async getAllTests() {
    try {
      const [rows] = await db.query("SELECT * FROM tests")
      return rows
    } catch (error) {
      console.error("Error in getAllTests:", error)
      throw error
    }
  }

  static async getTestById(id) {
    try {
      const [rows] = await db.query("SELECT * FROM tests WHERE id = ?", [id])
      return rows[0] || null
    } catch (error) {
      console.error("Error in getTestById:", error)
      throw error
    }
  }

  static async createTest(test_name, description) {
    try {
      const [result] = await db.query("INSERT INTO tests (test_name, description) VALUES (?, ?)", [
        test_name,
        description,
      ])
      return result
    } catch (error) {
      console.error("Error in createTest:", error)
      throw error
    }
  }

  static async updateTest(id, test_name, description) {
    try {
      const [result] = await db.query("UPDATE tests SET test_name = ?, description = ? WHERE id = ?", [
        test_name,
        description,
        id,
      ])
      return result
    } catch (error) {
      console.error("Error in updateTest:", error)
      throw error
    }
  }

  static async deleteTest(id) {
    try {
      const [result] = await db.query("DELETE FROM tests WHERE id = ?", [id])
      return result
    } catch (error) {
      console.error("Error in deleteTest:", error)
      throw error
    }
  }

  static async searchTests(searchTerm) {
    try {
      const [rows] = await db.query("SELECT * FROM tests WHERE test_name LIKE ?", [`%${searchTerm}%`])
      return rows
    } catch (error) {
      console.error("Error in searchTests:", error)
      throw error
    }
  }

  static async getTestCasesByTestId(testId) {
    try {
      const [rows] = await db.query(
        "SELECT tc.* FROM test_cases tc WHERE tc.test_id = ?",
        [testId]
      )
      return rows
    } catch (error) {
      console.error("Error in getTestCasesByTestId:", error)
      throw error
    }
  }
}

module.exports = Test

