const db = require("../config/db")

class TestResult {
  static async getTestStatistics() {
    try {
      // Get all tests with their test cases statistics
      const [rows] = await db.query(`
        SELECT 
          t.id,
          t.test_name,
          t.description,
          COUNT(tc.id) as total_cases,
          SUM(CASE WHEN tc.status = 'Passed' THEN 1 ELSE 0 END) as passed_cases,
          SUM(CASE WHEN tc.status = 'Failed' THEN 1 ELSE 0 END) as failed_cases,
          SUM(CASE WHEN tc.status = 'Not Started' THEN 1 ELSE 0 END) as not_started_cases
        FROM tests t
        LEFT JOIN test_cases tc ON t.id = tc.test_id
        GROUP BY t.id, t.test_name, t.description
        ORDER BY t.test_name
      `)
      return rows
    } catch (error) {
      console.error("Error in getTestStatistics:", error)
      throw error
    }
  }

  static async getTestCasesByStatus() {
    try {
      const [rows] = await db.query(`
        SELECT 
          status,
          COUNT(*) as count
        FROM test_cases
        GROUP BY status
      `)
      return rows
    } catch (error) {
      console.error("Error in getTestCasesByStatus:", error)
      throw error
    }
  }

  static async getTestCasesByFramework() {
    try {
      const [rows] = await db.query(`
        SELECT 
          framework,
          COUNT(*) as count
        FROM test_cases
        GROUP BY framework
      `)
      return rows
    } catch (error) {
      console.error("Error in getTestCasesByFramework:", error)
      throw error
    }
  }
}

module.exports = TestResult

