const db = require("../config/db")

class User {
  static async getUserByUsername(username) {
    try {
      const [rows] = await db.query("SELECT * FROM users WHERE username = ?", [username])
      return rows[0] || null
    } catch (error) {
      console.error("Error in getUserByUsername:", error)
      throw error
    }
  }

  static async getUserByEmail(email) {
    try {
      const [rows] = await db.query("SELECT * FROM users WHERE email = ?", [email])
      return rows[0] || null
    } catch (error) {
      console.error("Error in getUserByEmail:", error)
      throw error
    }
  }

  static async getUserById(id) {
    try {
      const [rows] = await db.query("SELECT * FROM users WHERE id = ?", [id])
      return rows[0] || null
    } catch (error) {
      console.error("Error in getUserById:", error)
      throw error
    }
  }

  static async createUser(username, email, password) {
    try {
      const [result] = await db.query(
        "INSERT INTO users (username, email, password, created_at) VALUES (?, ?, ?, NOW())",
        [username, email, password],
      )
      return result
    } catch (error) {
      console.error("Error in createUser:", error)
      throw error
    }
  }

  static async updateUser(id, userData) {
    try {
      const { username, email } = userData
      const [result] = await db.query("UPDATE users SET username = ?, email = ?, updated_at = NOW() WHERE id = ?", [
        username,
        email,
        id,
      ])
      return result
    } catch (error) {
      console.error("Error in updateUser:", error)
      throw error
    }
  }

  static async updatePassword(id, password) {
    try {
      const [result] = await db.query("UPDATE users SET password = ?, updated_at = NOW() WHERE id = ?", [password, id])
      return result
    } catch (error) {
      console.error("Error in updatePassword:", error)
      throw error
    }
  }
}

module.exports = User

