const express = require("express")
const router = express.Router()
const authController = require("../controllers/authController")
const { isAuthenticated } = require("../middleware/authMiddleware")

// Login routes
router.get("/login", authController.renderLogin)
router.post("/login", authController.login)

// Register routes
router.get("/register", authController.renderRegister)
router.post("/register", authController.register)

// Logout route
router.get("/logout", authController.logout)

// Dashboard route (protected)
router.get("/dashboard", isAuthenticated, authController.renderDashboard)

module.exports = router

