const express = require("express")
const router = express.Router()
const testCaseController = require("../controllers/testCaseController")
const { isAuthenticated } = require("../middleware/authMiddleware")

// List all test cases
router.get("/", isAuthenticated, testCaseController.getAllTestCases)

// Search test cases
router.get("/search", isAuthenticated, testCaseController.searchTestCases)

// Filter by framework
router.get("/framework", isAuthenticated, testCaseController.getTestCasesByFramework)

// Edit test case
router.get("/edit/:id", isAuthenticated, testCaseController.getTestCaseById)
router.post("/edit/:id", isAuthenticated, testCaseController.updateTestCase)

// Delete test case
router.get("/delete/:id", isAuthenticated, testCaseController.deleteTestCase)

// Add new test case
router.get("/add", isAuthenticated, testCaseController.renderAddTestCase)
router.post("/add", isAuthenticated, testCaseController.createTestCase)

module.exports = router

