const express = require("express")
const router = express.Router()
const testResultController = require("../controllers/testResultController")
const { isAuthenticated } = require("../middleware/authMiddleware")

// Show all test results
router.get("/", isAuthenticated, testResultController.getAllTestResults)

// Add new test result
router.get("/add", isAuthenticated, testResultController.renderAddTestResult)
router.post("/add", isAuthenticated, testResultController.addTestResult)

module.exports = router

