const express = require("express")
const router = express.Router()
const testController = require("../controllers/testController")
const { isAuthenticated } = require("../middleware/authMiddleware")

// List all tests
router.get("/", isAuthenticated, testController.getAllTests)

// Search tests
router.get("/search", isAuthenticated, testController.searchTests)

// Edit test
router.get("/edit/:id", isAuthenticated, testController.getTestById)
router.post("/edit/:id", isAuthenticated, testController.updateTest)

// Delete test
router.get("/delete/:id", isAuthenticated, testController.deleteTest)

// Add new test
router.get("/add", isAuthenticated, testController.renderAddTest)
router.post("/add", isAuthenticated, testController.createTest)

// View test cases for a specific test
router.get("/:id/cases", isAuthenticated, testController.getTestCases)

module.exports = router

