<?php  
error_reporting(E_ALL);
ini_set('display_errors', 1);

include 'components/connect.php';
session_start(); // ตรวจสอบว่ามี session หรือไม่
$user_id = $_SESSION['user_id'] ?? ''; // ตรวจสอบว่าผู้ใช้ล็อกอินหรือไม่

if(isset($_GET['get_id'])){
   $get_id = $_GET['get_id'];
} else {
   header('location:all_posts.php');
   exit();
}

if(isset($_POST['submit'])){
   if(!empty($user_id)){
      function create_unique_id(){
         return uniqid();
      }
      
      $id = create_unique_id();
      $title = filter_var($_POST['title'], FILTER_SANITIZE_STRING);
      $description = filter_var($_POST['description'], FILTER_SANITIZE_STRING);
      $rating = filter_var($_POST['rating'], FILTER_SANITIZE_STRING);
      
      try {
         $verify_review = $conn->prepare("SELECT * FROM `reviews` WHERE post_id = ? AND user_id = ?");
         $verify_review->execute([$get_id, $user_id]);
         
         if($verify_review->rowCount() > 0){
            $warning_msg[] = 'Your review already added!';
         } else {
            $add_review = $conn->prepare("INSERT INTO `reviews`(id, post_id, user_id, rating, title, description) VALUES(?,?,?,?,?,?)");
            $add_review->execute([$id, $get_id, $user_id, $rating, $title, $description]);
            $success_msg[] = 'Review added!';
         }
      } catch (PDOException $e) {
         die("Error: " . $e->getMessage());
      }
   } else {
      $warning_msg[] = 'Please login first!';
   }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
   <meta charset="UTF-8">
   <meta http-equiv="X-UA-Compatible" content="IE=edge">
   <meta name="viewport" content="width=device-width, initial-scale=1.0">
   <title>add review</title>
   <link rel="stylesheet" href="css/style.css">
</head>
<body>

<?php include 'components/header.php'; ?>

<section class="account-form">
   <form action="" method="post">
      <h3>post your review</h3>
      <p class="placeholder">review title <span>*</span></p>
      <input type="text" name="title" required maxlength="50" placeholder="enter review title" class="box">
      <p class="placeholder">review description</p>
      <textarea name="description" class="box" placeholder="enter review description" maxlength="1000" cols="30" rows="10"></textarea>
      <p class="placeholder">review rating <span>*</span></p>
      <select name="rating" class="box" required>
         <option value="1">1</option>
         <option value="2">2</option>
         <option value="3">3</option>
         <option value="4">4</option>
         <option value="5">5</option>
      </select>
      <input type="submit" value="submit review" name="submit" class="btn">
      <a href="view_post.php?get_id=<?= htmlspecialchars($get_id); ?>" class="option-btn">go back</a>
   </form>
</section>

<script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.2/sweetalert.min.js"></script>
<script src="js/script.js"></script>
</body>
</html>