<?php

include 'components/connect.php';

?>

<!DOCTYPE html>
<html lang="en">
<head>
   <meta charset="UTF-8">
   <meta http-equiv="X-UA-Compatible" content="IE=edge">
   <meta name="viewport" content="width=device-width, initial-scale=1.0">
  

   <!-- custom css file link  -->
   <link rel="stylesheet" href="css/style.css">

</head>
<body>
   
<!-- header section starts  -->
<?php include 'components/header.php'; ?>
<!-- header section ends -->

<!-- search bar starts -->
<form action="" method="GET" class="search-container">
   <input type="text" name="search" class="search-input" placeholder="Search posts..." value="
   <?php if(isset($_GET['search'])) echo $_GET['search']; ?>">
   <button type="submit" class="search-button"><i class="fa-solid fa-magnifying-glass"></i></button>
</form>
<!-- search bar ends -->

<!-- view all posts section starts -->
<section class="all-posts">
   <div class="heading"><h1>all posts</h1></div>
   <div class="box-container">
   <?php
      $search = isset($_GET['search']) ? trim($_GET['search']) : '';
      
      if ($search) {
         $select_posts = $conn->prepare("SELECT * FROM `posts` WHERE `title` LIKE :search");
         $select_posts->execute(['search' => "%$search%"]);
      } else {
         $select_posts = $conn->prepare("SELECT * FROM `posts`");
         $select_posts->execute();
      }
      
      if($select_posts->rowCount() > 0){
         while($fetch_post = $select_posts->fetch(PDO::FETCH_ASSOC)){
         $post_id = $fetch_post['id'];
         $count_reviews = $conn->prepare("SELECT * FROM `reviews` WHERE post_id = ?");
         $count_reviews->execute([$post_id]);
         $total_reviews = $count_reviews->rowCount();
   ?>
   <div class="box">
      <img src="uploaded_files/<?= $fetch_post['image']; ?>" alt="" class="image">
      <h3 class="title"><?= $fetch_post['title']; ?></h3>
      <p class="total-reviews"><i class="fas fa-star"></i> <span><?= $total_reviews; ?></span></p>
      <a href="view_post.php?get_id=<?= $post_id; ?>" class="inline-btn">view post</a>
   </div>
   <?php
      }
   }else{
      echo '<p class="empty">No posts found!</p>';
   }
   ?>
   </div>
</section>
<!-- view all posts section ends -->

<!-- sweetalert cdn link  -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.2/sweetalert.min.js"></script>
<!-- custom js file link  -->
<script src="js/script.js"></script>
<?php include 'components/alers.php'; ?>
</body>
</html>