const express = require("express");
const app = express();
const session = require("express-session");
const bodyParser = require("body-parser");
const dotenv = require("dotenv");
const path = require("path");
const db = require("./config/db");
const authRoutes = require("./routes/authRoutes");
const dentistRoutes = require("./routes/dentistRoutes");

dotenv.config();

// ให้ Express ใช้ไฟล์ static จากโฟลเดอร์ public
app.use(express.static(path.join(__dirname, 'public')));

// ตั้งค่า Middleware
app.use(bodyParser.urlencoded({ extended: false }));
app.use(bodyParser.json());

// ตั้งค่า session
app.use(
    session({
        secret: "secret_key",
        resave: false,
        saveUninitialized: true,
    })
);

// ตั้งค่า View Engine เป็น EJS
app.set("view engine", "ejs");
app.set("views", path.join(__dirname, "views")); // ตั้งค่าตำแหน่งของโฟลเดอร์ views


// กำหนดเส้นทาง (Routes)
app.use('/', authRoutes);
app.use('/dentist', dentistRoutes);


// เพิ่ม Route หลัก ถ้าเปิด localhost:3000 จะไปที่หน้า login อัตโนมัติ
app.get("/", (req, res) => {
    res.redirect("/login");
});

// กำหนด Route เมื่อเกิดข้อผิดพลาด (Page Not Found)
app.use((req, res) => {
    res.status(404).send("404 Not Found");
});

// รันเซิร์ฟเวอร์
const PORT = process.env.PORT || 3000;
app.listen(PORT, () => console.log(`Server running on http://localhost:${PORT}`));