const db = require('../config/db');

class QueueDetail {
    static async getQueueDetails(searchQuery = '') {

        const searchPattern = searchQuery ? `%${searchQuery}%` : '%'; 

        const query = `
            SELECT p.patient_id AS id,
                    CONCAT(p.fname, ' ', p.lname) AS patient_name,
                    p.phone AS phone,
                    'ไม่มี' AS treatment_history
            FROM queuedetail qd
            JOIN patient p ON qd.patient_id = p.patient_id
            WHERE CONCAT(p.fname, ' ', p.lname) LIKE ? OR p.patient_id LIKE ?
            GROUP BY p.patient_id  
        `;

        return new Promise((resolve, reject) => { 
            db.query(query, [searchPattern, searchPattern], (error, results) => {
                if (error) {
                    reject(error);
                }
                resolve(results);  
            });
        });
    }

    static async getQueueDetailById(queuedetail_id) {
        const query = `
            SELECT qd.queuedetail_id, qd.date AS treatment_date,
                CONCAT(p.fname, ' ', p.lname) AS patient_name,
                t.treatment_name, qd.patient_id
            FROM queuedetail qd
            JOIN patient p ON qd.patient_id = p.patient_id
            JOIN treatment t ON qd.treatment_id = t.treatment_id
            WHERE qd.queuedetail_id = ?
        `;

        return new Promise((resolve, reject) => {
            db.query(query, [queuedetail_id], (error, results) => {
                if (error) {
                    reject(error);
                }
                if (results.length === 0) {
                    resolve(null);
                } else {
                    resolve(results[0]);
                }
            });
        });
    }

    static async getQueueDetailsByPatientId(patient_id) {
        const query = `
            SELECT qd.queuedetail_id, qd.date AS treatment_date, 
                CONCAT(p.fname, ' ', p.lname) AS patient_name,
                t.treatment_name
            FROM queuedetail qd
            JOIN patient p ON qd.patient_id = p.patient_id
            JOIN treatment t ON qd.treatment_id = t.treatment_id
            WHERE qd.patient_id = ?
            ORDER BY qd.date DESC LIMIT 1;
        `;

        return new Promise((resolve, reject) => {
            db.query(query, [patient_id], (error, results) => {
                if (error) {
                    console.error("Database query error:", error);  // แสดงข้อผิดพลาดจากฐานข้อมูล
                    reject(error);
                    return;
                }

                console.log("Query results:", results);
    
                if (!results || results.length === 0) {
                    console.log("No results found for patient_id:", patient_id);  // ถ้าไม่พบข้อมูล
                    resolve(null);  // คืนค่า null ถ้าไม่มีข้อมูล
                } else {
                    resolve(results[0]);  // คืนค่าการจองล่าสุด
                }
            });
        });
    }



}

module.exports = QueueDetail;