const express = require('express');
const router = express.Router();
const DentistController = require('../controllers/DentistController');

router.get('/treatment', DentistController.showQueueDetailsById);

router.get('/treatmenthistory/:id', DentistController.showTreatmentHistory);

router.get('/edittreatmenthis/:id', DentistController.showEditTreatmentForm);
router.post('/updatetreatmenthis', DentistController.updateTreatmentHistory);
router.post('/deletetreatmenthis/:id', DentistController.deleteTreatmentHistory);

router.get('/addtreatmenthis/:queuedetail_id', DentistController.showAddTreatmentForm);
router.post('/addtreatmenthis', DentistController.addTreatmentHistory);



module.exports = router;