const User = require("../models/User");
const bcrypt = require("bcryptjs");
const jwt = require("jsonwebtoken");

exports.register = async (req, res) => {
    try {
        //ส่งข้อมูลไปให้ User.creatuser
        await User.createUser(req.body);
        res.redirect("/login");
    } catch (err) {
        console.error("Error register user:", err);
        res.status(500).send("Error registering user");
    }
};

exports.login = async (req, res) => {
    const { email, password } = req.body;

    if (!email || !password) {
        return res.status(400).send("Email and password are required.");
    }

    const user = await User.findByEmail(email);

    // ถ้าไม่พบผู้ใช้
    if (!user) {
        console.log("No user found with this email.");
        return res.status(401).send("Invalid email or password");
    }

    // ตรวจสอบรหัสผ่าน
    if(!(await bcrypt.compare(password, user.password))) {
        console.log("Invalid credentials!"); // ตรวจสอบเมื่อรหัสผ่านไม่ตรง
        return res.status(401).send("Invalid email or password");
    }

    // เก็บข้อมูลผู้ใช้ใน session
    req.session.user = user;

        if (user.role_id === 1) {
            return res.redirect("/dentist/treatment");
        }

    res.redirect("/dashboard")
};

exports.logout = (req, res) => {
    req.session.destroy((err) => {
        if (err) {
            console.log("เกิดข้อผิดพลาดระหว่างการทำลาย session:", err);
            return res.status(500).send("เกิดข้อผิดพลาดในการออกจากระบบ");
        }
        res.redirect("/login");
    })
}
