//middleware/authMiddleware.js

const checkDentistRole = (req, res, next) => {
    if (!req.seesion.user || req.seesion.user.role !== 'dentist') {
        return res.status(403).send("Access denined. Dentist only,");
    }
    next(); //ผู้ใช้เป็น dentist ให้ดำเนินการต่อ
}

const checkPatientRole = (req, res, next) => {
    if (!req.seesion.user || req.seesion.user.role !== 'patient') {
        return res.status(403).send("Access denined. Patient only,");
    }
    next(); 
}

// ส่งออกทั้งสอง middleware ในออบเจ็กต์เดียวกัน
module.exports = { checkDentistRole, checkPatientRole };

