"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Queue = void 0;
const typeorm_1 = require("typeorm");
const machine_entity_1 = require("../../machines/entities/machine.entity");
const order_entity_1 = require("../../orders/entities/order.entity");
const employee_entity_1 = require("../../employees/entities/employee.entity");
let Queue = class Queue {
};
exports.Queue = Queue;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)(),
    __metadata("design:type", Number)
], Queue.prototype, "queueID", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => machine_entity_1.Machine, (machine) => machine.queues, {
        onDelete: 'CASCADE',
    }),
    __metadata("design:type", machine_entity_1.Machine)
], Queue.prototype, "machine", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => order_entity_1.Order, (order) => order.queues, { onDelete: 'CASCADE' }),
    __metadata("design:type", order_entity_1.Order)
], Queue.prototype, "order", void 0);
__decorate([
    (0, typeorm_1.ManyToMany)(() => employee_entity_1.Employee, (employee) => employee.queues),
    (0, typeorm_1.JoinTable)({
        name: 'QueueAssignment',
        joinColumn: { name: 'QueueID', referencedColumnName: 'queueID' },
        inverseJoinColumn: {
            name: 'EmployeeID',
            referencedColumnName: 'employeeID',
        },
    }),
    __metadata("design:type", Array)
], Queue.prototype, "employees", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", Number)
], Queue.prototype, "pageID", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'timestamp', nullable: true }),
    __metadata("design:type", Date)
], Queue.prototype, "startTime", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'timestamp', nullable: true }),
    __metadata("design:type", Date)
], Queue.prototype, "finishTime", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'varchar', length: 50 }),
    __metadata("design:type", String)
], Queue.prototype, "status", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'varchar', length: 50 }),
    __metadata("design:type", String)
], Queue.prototype, "bottleSize", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", Number)
], Queue.prototype, "producedQuantity", void 0);
exports.Queue = Queue = __decorate([
    (0, typeorm_1.Entity)('queue')
], Queue);
//# sourceMappingURL=queue.entity.js.map