"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppModule = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const serve_static_1 = require("@nestjs/serve-static");
const path_1 = require("path");
const typeorm_2 = require("typeorm");
const app_controller_1 = require("./app.controller");
const app_service_1 = require("./app.service");
const users_module_1 = require("./users/users.module");
const roles_module_1 = require("./roles/roles.module");
const auth_module_1 = require("./auth/auth.module");
const queues_module_1 = require("./queues/queues.module");
const employees_module_1 = require("./employees/employees.module");
const machines_module_1 = require("./machines/machines.module");
const pages_module_1 = require("./pages/pages.module");
const orders_module_1 = require("./orders/orders.module");
const orderpiorities_module_1 = require("./orderpiorities/orderpiorities.module");
const machine_details_module_1 = require("./machine_details/machine_details.module");
const material_stocks_module_1 = require("./material_stocks/material_stocks.module");
const products_module_1 = require("./products/products.module");
const order_details_module_1 = require("./order_details/order_details.module");
const product_stocks_module_1 = require("./product_stocks/product_stocks.module");
const customers_module_1 = require("./customers/customers.module");
const materials_module_1 = require("./materials/materials.module");
const material_restock_order_module_1 = require("./material_restock_order/material_restock_order.module");
const stock_configs_module_1 = require("./stock_configs/stock_configs.module");
const production_targets_module_1 = require("./production_targets/production_targets.module");
const queue_types_module_1 = require("./queue-types/queue-types.module");
const user_entity_1 = require("./users/entities/user.entity");
const role_entity_1 = require("./roles/entities/role.entity");
const queue_entity_1 = require("./queues/entities/queue.entity");
const machine_entity_1 = require("./machines/entities/machine.entity");
const machine_detail_entity_1 = require("./machine_details/entities/machine_detail.entity");
const employee_entity_1 = require("./employees/entities/employee.entity");
const customer_entity_1 = require("./customers/entities/customer.entity");
const material_entity_1 = require("./materials/entities/material.entity");
const material_stock_entity_1 = require("./material_stocks/entities/material_stock.entity");
const material_restock_order_entity_1 = require("./material_restock_order/entities/material_restock_order.entity");
const order_detail_entity_1 = require("./order_details/entities/order_detail.entity");
const orderpiority_entity_1 = require("./orderpiorities/entities/orderpiority.entity");
const order_entity_1 = require("./orders/entities/order.entity");
const page_entity_1 = require("./pages/entities/page.entity");
const product_stock_entity_1 = require("./product_stocks/entities/product_stock.entity");
const product_entity_1 = require("./products/entities/product.entity");
const recipes_module_1 = require("./recipes/recipes.module");
const recipe_ingredients_module_1 = require("./recipe_ingredients/recipe_ingredients.module");
const recipe_entity_1 = require("./recipes/entities/recipe.entity");
const recipe_ingredient_entity_1 = require("./recipe_ingredients/entities/recipe_ingredient.entity");
const stock_config_entity_1 = require("./stock_configs/entities/stock_config.entity");
const production_target_entity_1 = require("./production_targets/entities/production_target.entity");
const queue_type_entity_1 = require("./queue-types/entities/queue-type.entity");
let AppModule = class AppModule {
    constructor(dataSource) {
        this.dataSource = dataSource;
    }
};
exports.AppModule = AppModule;
exports.AppModule = AppModule = __decorate([
    (0, common_1.Module)({
        imports: [
            typeorm_1.TypeOrmModule.forRoot({
                type: 'mysql',
                host: 'localhost',
                port: 3306,
                username: 'root',
                password: '',
                database: 'water',
                entities: [
                    user_entity_1.User,
                    role_entity_1.Role,
                    queue_entity_1.Queue,
                    machine_entity_1.Machine,
                    machine_detail_entity_1.MachineDetail,
                    employee_entity_1.Employee,
                    customer_entity_1.Customer,
                    material_entity_1.Material,
                    material_stock_entity_1.MaterialStock,
                    material_restock_order_entity_1.MaterialRestockOrder,
                    order_detail_entity_1.OrderDetail,
                    orderpiority_entity_1.OrderPriority,
                    order_entity_1.Order,
                    page_entity_1.Page,
                    product_stock_entity_1.ProductStock,
                    product_entity_1.Product,
                    recipe_entity_1.Recipe,
                    recipe_ingredient_entity_1.RecipeIngredient,
                    stock_config_entity_1.StockConfig,
                    production_target_entity_1.ProductionTarget,
                    queue_type_entity_1.QueueType,
                ],
                synchronize: true,
            }),
            serve_static_1.ServeStaticModule.forRoot({
                rootPath: (0, path_1.join)(__dirname, '..', 'public'),
            }),
            users_module_1.UsersModule,
            roles_module_1.RolesModule,
            auth_module_1.AuthModule,
            queues_module_1.QueuesModule,
            employees_module_1.EmployeesModule,
            machines_module_1.MachinesModule,
            pages_module_1.PagesModule,
            orders_module_1.OrdersModule,
            orderpiorities_module_1.OrderPriorityModule,
            machine_details_module_1.MachineDetailsModule,
            material_stocks_module_1.MaterialStocksModule,
            products_module_1.ProductsModule,
            order_details_module_1.OrderDetailsModule,
            product_stocks_module_1.ProductStocksModule,
            customers_module_1.CustomersModule,
            materials_module_1.MaterialsModule,
            material_restock_order_module_1.MaterialRestockOrderModule,
            recipes_module_1.RecipesModule,
            recipe_ingredients_module_1.RecipeIngredientsModule,
            stock_configs_module_1.StockConfigsModule,
            production_targets_module_1.ProductionTargetsModule,
            queue_types_module_1.QueueTypesModule,
        ],
        controllers: [app_controller_1.AppController],
        providers: [app_service_1.AppService],
    }),
    __metadata("design:paramtypes", [typeorm_2.DataSource])
], AppModule);
//# sourceMappingURL=app.module.js.map