"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@nestjs/core");
const swagger_1 = require("@nestjs/swagger");
const app_module_1 = require("./app.module");
const common_1 = require("@nestjs/common");
const child_process_1 = require("child_process");
async function bootstrap() {
    const app = await core_1.NestFactory.create(app_module_1.AppModule);
    const config = new swagger_1.DocumentBuilder()
        .setTitle('Production Planning API')
        .setDescription('API for managing production schedules, machines, and workforce in a manufacturing system.')
        .setVersion('1.0')
        .addTag('production')
        .addTag('machines')
        .addTag('orders')
        .addTag('employees')
        .build();
    const document = swagger_1.SwaggerModule.createDocument(app, config);
    swagger_1.SwaggerModule.setup('api', app, document);
    app.useGlobalPipes(new common_1.ValidationPipe({ transform: true }));
    app.enableCors();
    (0, child_process_1.exec)('python -m uvicorn src.queues.AutoQueue.Autoqueue:app --host 127.0.0.1 --port 9000 --reload', (error, stdout, stderr) => {
        if (error) {
            console.error(`❌ Error starting FastAPI: ${error.message}`);
            return;
        }
        if (stderr) {
            console.error(`⚠️ FastAPI stderr: ${stderr}`);
            return;
        }
        console.log(`✅ FastAPI started successfully: ${stdout}`);
    });
    await app.listen(4000);
    console.log('✅ NestJS is running on http://localhost:4000');
    console.log('✅ FastAPI started successfully: http://localhost:9000');
}
bootstrap();
//# sourceMappingURL=main.js.map