"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MaterialStocksService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const material_stock_entity_1 = require("./entities/material_stock.entity");
const material_entity_1 = require("../materials/entities/material.entity");
const material_restock_order_entity_1 = require("../material_restock_order/entities/material_restock_order.entity");
let MaterialStocksService = class MaterialStocksService {
    constructor(materialStockRepo, materialRepo, restockOrderRepo) {
        this.materialStockRepo = materialStockRepo;
        this.materialRepo = materialRepo;
        this.restockOrderRepo = restockOrderRepo;
    }
    async create(createDto) {
        const material = await this.materialRepo.findOne({
            where: { MaterialID: createDto.materialID },
        });
        const restockOrder = await this.restockOrderRepo.findOne({
            where: { MaterialRestockOrderID: createDto.materialRestockOrderID },
        });
        if (!material || !restockOrder) {
            throw new common_1.NotFoundException('Material or Restock Order not found');
        }
        const newStock = this.materialStockRepo.create({
            QuantityOrdered: createDto.QuantityOrdered,
            QuantityReceived: createDto.QuantityReceived || 0,
            Status: createDto.Status,
            material,
            restockOrder,
        });
        return this.materialStockRepo.save(newStock);
    }
    async findAll() {
        return this.materialStockRepo.find({
            relations: ['material', 'restockOrder'],
        });
    }
    async findOne(id) {
        const stock = await this.materialStockRepo.findOne({
            where: { MaterialID: id },
            relations: ['material', 'restockOrder'],
        });
        if (!stock) {
            throw new common_1.NotFoundException(`Material stock #${id} not found`);
        }
        return stock;
    }
    async update(id, updateDto) {
        const stock = await this.materialStockRepo.findOne({
            where: { MaterialID: id },
        });
        if (!stock) {
            throw new common_1.NotFoundException(`Material stock #${id} not found`);
        }
        const updated = Object.assign(stock, updateDto);
        return this.materialStockRepo.save(updated);
    }
    async remove(id) {
        const stock = await this.materialStockRepo.findOne({
            where: { MaterialID: id },
        });
        if (!stock) {
            throw new common_1.NotFoundException(`Material stock #${id} not found`);
        }
        await this.materialStockRepo.remove(stock);
        return { message: `Material stock #${id} removed successfully` };
    }
};
exports.MaterialStocksService = MaterialStocksService;
exports.MaterialStocksService = MaterialStocksService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(material_stock_entity_1.MaterialStock)),
    __param(1, (0, typeorm_1.InjectRepository)(material_entity_1.Material)),
    __param(2, (0, typeorm_1.InjectRepository)(material_restock_order_entity_1.MaterialRestockOrder)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository])
], MaterialStocksService);
//# sourceMappingURL=material_stocks.service.js.map