"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var ProductionTargetsController_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductionTargetsController = void 0;
const common_1 = require("@nestjs/common");
const production_targets_service_1 = require("./production_targets.service");
const create_production_target_dto_1 = require("./dto/create-production_target.dto");
const update_production_target_dto_1 = require("./dto/update-production_target.dto");
let ProductionTargetsController = ProductionTargetsController_1 = class ProductionTargetsController {
    constructor(productionTargetsService) {
        this.productionTargetsService = productionTargetsService;
        this.logger = new common_1.Logger(ProductionTargetsController_1.name);
    }
    async create(createProductionTargetDto) {
        this.logger.log(`POST /production-targets - Creating production target for itemID: ${createProductionTargetDto.itemID}`);
        return await this.productionTargetsService.create(createProductionTargetDto);
    }
    async createMany(createManyDto) {
        this.logger.log(`POST /production-targets/many - Creating multiple production targets`);
        return await this.productionTargetsService.createMany(createManyDto);
    }
    async findByDate(dateStr) {
        this.logger.log(`GET /production-targets/by-date?dateStr=${dateStr}`);
        return await this.productionTargetsService.findByDate(dateStr);
    }
    async findAll() {
        this.logger.log(`GET /production-targets - Retrieving all production targets`);
        return await this.productionTargetsService.findAll();
    }
    async findOne(id) {
        this.logger.log(`GET /production-targets/${id} - Retrieving production target`);
        return await this.productionTargetsService.findOne(Number(id));
    }
    async update(id, updateProductionTargetDto) {
        this.logger.log(`PUT /production-targets/${id} - Updating production target`);
        return await this.productionTargetsService.update(Number(id), updateProductionTargetDto);
    }
    async deleteProductionTargets(dateStr) {
        this.logger.log(`DELETE /production-targets/from-date?dateStr=${dateStr}`);
        return await this.productionTargetsService.deleteProductionTargetsFromDate(dateStr);
    }
    async remove(id) {
        this.logger.log(`DELETE /production-targets/${id} - Removing production target`);
        return await this.productionTargetsService.remove(Number(id));
    }
};
exports.ProductionTargetsController = ProductionTargetsController;
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_production_target_dto_1.CreateProductionTargetDto]),
    __metadata("design:returntype", Promise)
], ProductionTargetsController.prototype, "create", null);
__decorate([
    (0, common_1.Post)('many'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_production_target_dto_1.CreateManyProductionTargetsDto]),
    __metadata("design:returntype", Promise)
], ProductionTargetsController.prototype, "createMany", null);
__decorate([
    (0, common_1.Get)('by-date'),
    __param(0, (0, common_1.Query)('dateStr')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], ProductionTargetsController.prototype, "findByDate", null);
__decorate([
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ProductionTargetsController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], ProductionTargetsController.prototype, "findOne", null);
__decorate([
    (0, common_1.Put)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_production_target_dto_1.UpdateProductionTargetDto]),
    __metadata("design:returntype", Promise)
], ProductionTargetsController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)('from-date'),
    __param(0, (0, common_1.Query)('dateStr')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], ProductionTargetsController.prototype, "deleteProductionTargets", null);
__decorate([
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], ProductionTargetsController.prototype, "remove", null);
exports.ProductionTargetsController = ProductionTargetsController = ProductionTargetsController_1 = __decorate([
    (0, common_1.Controller)('production-targets'),
    __metadata("design:paramtypes", [production_targets_service_1.ProductionTargetsService])
], ProductionTargetsController);
//# sourceMappingURL=production_targets.controller.js.map