import { Repository } from 'typeorm';
import { ProductionTarget } from './entities/production_target.entity';
import { Order } from '@/orders/entities/order.entity';
import { Product } from '@/products/entities/product.entity';
import { Material } from '@/materials/entities/material.entity';
import { ProductStock } from '@/product_stocks/entities/product_stock.entity';
import { MaterialStock } from '@/material_stocks/entities/material_stock.entity';
import { CreateProductionTargetDto, CreateManyProductionTargetsDto } from './dto/create-production_target.dto';
import { UpdateProductionTargetDto } from './dto/update-production_target.dto';
export declare class ProductionTargetsService {
    private readonly productionTargetRepository;
    private readonly orderRepository;
    private readonly productRepository;
    private readonly materialRepository;
    private readonly productStockRepository;
    private readonly materialStockRepository;
    private readonly logger;
    constructor(productionTargetRepository: Repository<ProductionTarget>, orderRepository: Repository<Order>, productRepository: Repository<Product>, materialRepository: Repository<Material>, productStockRepository: Repository<ProductStock>, materialStockRepository: Repository<MaterialStock>);
    create(createProductionTargetDto: CreateProductionTargetDto): Promise<ProductionTarget>;
    createMany(createManyDto: CreateManyProductionTargetsDto): Promise<ProductionTarget[]>;
    findAll(): Promise<any[]>;
    findOne(id: number): Promise<ProductionTarget>;
    findByDate(dateStr: string): Promise<ProductionTarget[]>;
    update(id: number, updateProductionTargetDto: UpdateProductionTargetDto): Promise<ProductionTarget>;
    remove(id: number): Promise<ProductionTarget>;
    private calculateProductionHours;
    private updateStatusAndStock;
    private updateProductStock;
    private updateMaterialStock;
    private rollbackStock;
    deleteProductionTargetsFromDate(dateStr: string): Promise<{
        deletedCount: number;
    }>;
}
