"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const product_entity_1 = require("./entities/product.entity");
const product_stock_entity_1 = require("../product_stocks/entities/product_stock.entity");
let ProductsService = class ProductsService {
    constructor(productRepository, productStockRepository) {
        this.productRepository = productRepository;
        this.productStockRepository = productStockRepository;
    }
    async create(createProductDto) {
        const product = this.productRepository.create(createProductDto);
        return await this.productRepository.save(product);
    }
    async findAll() {
        return await this.productRepository.find();
    }
    async findOne(id) {
        return await this.productRepository.findOne({ where: { ProductID: id } });
    }
    async update(productId, updateDto) {
        const product = await this.productRepository.findOne({
            where: { ProductID: productId },
            relations: ['productStocks'],
        });
        if (!product) {
            throw new common_1.NotFoundException(`Product with ID ${productId} not found`);
        }
        const oldQuantity = product.quantityInStock;
        Object.assign(product, updateDto);
        if (updateDto.quantityInStock !== undefined &&
            updateDto.quantityInStock !== oldQuantity) {
            const quantityDifference = updateDto.quantityInStock - oldQuantity;
            const productStock = this.productStockRepository.create({
                product,
                quantityReceived: quantityDifference,
                status: quantityDifference > 0 ? 'เติมStock' : 'ขายออก',
                addDate: new Date(),
            });
            product.productStocks.push(productStock);
            await this.productStockRepository.save(productStock);
        }
        return await this.productRepository.save(product);
    }
    async createOrUpdate(createProductDto) {
        const product = await this.productRepository.findOne({
            where: { ProductID: createProductDto.ProductID },
            relations: ['productStocks'],
        });
        if (product) {
            return this.update(product.ProductID, createProductDto);
        }
        return await this.create(createProductDto);
    }
    async remove(id) {
        await this.productRepository.delete(id);
    }
};
exports.ProductsService = ProductsService;
exports.ProductsService = ProductsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(product_entity_1.Product)),
    __param(1, (0, typeorm_1.InjectRepository)(product_stock_entity_1.ProductStock)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository])
], ProductsService);
//# sourceMappingURL=products.service.js.map