import { QueuesService } from './queues.service';
import { CreateQueueDto } from './dto/create-queue.dto';
import { UpdateQueueDto } from './dto/update-queue.dto';
import { Queue } from './entities/queue.entity';
export declare class QueuesController {
    private readonly queuesService;
    private readonly logger;
    constructor(queuesService: QueuesService);
    create(createQueueDto: CreateQueueDto): Promise<{
        message: string;
        queue: Queue;
    }>;
    createMultiple(createQueueDtos: CreateQueueDto[]): Promise<{
        message: string;
        queues: any[];
    }>;
    getLatestQueues(dateStr?: string): Promise<{
        queues: Queue[];
    }>;
    findAll(): Promise<Queue[]>;
    findOne(id: string): Promise<Queue>;
    update(id: string, updateQueueDto: UpdateQueueDto): Promise<{
        QueueID: number;
        machine: import("../machines/entities/machine.entity").Machine;
        page: import("../pages/entities/page.entity").Page;
        order: import("../orders/entities/order.entity").Order;
        employees: import("../employees/entities/employee.entity").Employee[];
        QueueType: import("../queue-types/entities/queue-type.entity").QueueType;
        startTime: Date;
        finishTime: Date;
        status: string;
        bottleSize: string;
        producedQuantity: number;
        createdAt: Date;
    } & Queue>;
    deleteNewlyCreatedQueues(dateStr: string): Promise<{
        deletedCount: number;
    }>;
    remove(id: string): Promise<{
        message: string;
        deletedQueue: Queue;
    }>;
}
