import { Repository } from 'typeorm';
import { Queue } from './entities/queue.entity';
import { CreateQueueDto } from './dto/create-queue.dto';
import { UpdateQueueDto } from './dto/update-queue.dto';
import { Machine } from '@/machines/entities/machine.entity';
import { Page } from '@/pages/entities/page.entity';
import { Order } from '@/orders/entities/order.entity';
import { Employee } from '@/employees/entities/employee.entity';
export declare class QueuesService {
    private readonly queueRepository;
    private readonly machineRepository;
    private readonly pageRepository;
    private readonly orderRepository;
    private readonly employeeRepository;
    private readonly logger;
    deleteByDate(dateStr: string): {
        deletedCount: number;
    } | PromiseLike<{
        deletedCount: number;
    }>;
    constructor(queueRepository: Repository<Queue>, machineRepository: Repository<Machine>, pageRepository: Repository<Page>, orderRepository: Repository<Order>, employeeRepository: Repository<Employee>);
    getLatestQueuesFromDate(dateStr?: string): Promise<Queue[]>;
    create(createQueueDto: CreateQueueDto): Promise<{
        message: string;
        queue: Queue;
    }>;
    createMultiple(createQueueDtos: CreateQueueDto[]): Promise<{
        message: string;
        queues: any[];
    }>;
    findAll(): Promise<Queue[]>;
    findOne(id: number): Promise<Queue>;
    update(id: number, updateQueueDto: UpdateQueueDto): Promise<{
        QueueID: number;
        machine: Machine;
        page: Page;
        order: Order;
        employees: Employee[];
        QueueType: import("../queue-types/entities/queue-type.entity").QueueType;
        startTime: Date;
        finishTime: Date;
        status: string;
        bottleSize: string;
        producedQuantity: number;
        createdAt: Date;
    } & Queue>;
    remove(id: number): Promise<{
        message: string;
        deletedQueue: Queue;
    }>;
    deleteNewlyCreatedQueuesFromDate(dateStr: string): Promise<{
        deletedCount: number;
    }>;
}
