"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StockConfigController = void 0;
const common_1 = require("@nestjs/common");
const stock_configs_service_1 = require("./stock_configs.service");
const create_stock_config_dto_1 = require("./dto/create-stock_config.dto");
const update_stock_config_dto_1 = require("./dto/update-stock_config.dto");
let StockConfigController = class StockConfigController {
    constructor(stockConfigService) {
        this.stockConfigService = stockConfigService;
    }
    async create(createStockConfigDto) {
        return this.stockConfigService.create(createStockConfigDto);
    }
    async findAll(pageId) {
        const parsedPageId = pageId ? parseInt(pageId, 10) : undefined;
        return this.stockConfigService.findAll(parsedPageId);
    }
    async findOne(id) {
        const stockConfig = await this.stockConfigService.findOne(id);
        if (!stockConfig)
            throw new common_1.NotFoundException(`StockConfig with ID ${id} not found`);
        return stockConfig;
    }
    async updateMany(body) {
        return this.stockConfigService.updateMany(body);
    }
    async update(id, updateStockConfigDto) {
        return this.stockConfigService.update(id, updateStockConfigDto);
    }
    async remove(id) {
        return this.stockConfigService.remove(id);
    }
};
exports.StockConfigController = StockConfigController;
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_stock_config_dto_1.CreateStockConfigDto]),
    __metadata("design:returntype", Promise)
], StockConfigController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)('pageId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], StockConfigController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], StockConfigController.prototype, "findOne", null);
__decorate([
    (0, common_1.Patch)('batch'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_stock_config_dto_1.BatchUpdateManyStockConfigDto]),
    __metadata("design:returntype", Promise)
], StockConfigController.prototype, "updateMany", null);
__decorate([
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, update_stock_config_dto_1.UpdateStockConfigDto]),
    __metadata("design:returntype", Promise)
], StockConfigController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], StockConfigController.prototype, "remove", null);
exports.StockConfigController = StockConfigController = __decorate([
    (0, common_1.Controller)('stock-config'),
    __metadata("design:paramtypes", [stock_configs_service_1.StockConfigService])
], StockConfigController);
//# sourceMappingURL=stock_configs.controller.js.map