import { Repository } from 'typeorm';
import { StockConfig } from './entities/stock_config.entity';
import { BatchUpdateManyStockConfigDto, CreateStockConfigDto } from './dto/create-stock_config.dto';
import { UpdateStockConfigDto } from './dto/update-stock_config.dto';
import { Page } from '@/pages/entities/page.entity';
import { Product } from '@/products/entities/product.entity';
import { Material } from '@/materials/entities/material.entity';
export declare class StockConfigService {
    private readonly stockConfigRepository;
    private readonly productRepository;
    private readonly materialRepository;
    private readonly pageRepository;
    constructor(stockConfigRepository: Repository<StockConfig>, productRepository: Repository<Product>, materialRepository: Repository<Material>, pageRepository: Repository<Page>);
    create(createStockConfigDto: CreateStockConfigDto): Promise<{
        message: string;
        stockConfig: {
            StockConfigID: number;
            itemID: number;
            itemType: "PRODUCT" | "MATERIAL";
            priorityLevel: number;
            targetStockLevel: number;
            status: string;
            lastUpdated: Date;
            page: {
                PageID: number;
                createdAt: Date;
                updatedAt: Date;
            };
        };
    }>;
    private reorderPrioritiesInPage;
    findAll(pageId?: number): Promise<{
        itemName: string;
        itemDetail: any;
        StockConfigID: number;
        itemID: number;
        itemType: "PRODUCT" | "MATERIAL";
        page: Page;
        priorityLevel: number;
        targetStockLevel: number;
        status: string;
        lastUpdated: Date;
    }[]>;
    findOne(id: number): Promise<{
        itemName: string;
        itemDetail: any;
        StockConfigID: number;
        itemID: number;
        itemType: "PRODUCT" | "MATERIAL";
        page: Page;
        priorityLevel: number;
        targetStockLevel: number;
        status: string;
        lastUpdated: Date;
    }>;
    update(id: number, updateStockConfigDto: UpdateStockConfigDto): Promise<{
        itemID: number;
        itemType: "PRODUCT" | "MATERIAL";
        PageID?: number;
        priorityLevel: number;
        targetStockLevel: number;
        status: string;
        StockConfigID: number;
        page: Page;
        lastUpdated: Date;
    } & StockConfig>;
    updateMany(data: BatchUpdateManyStockConfigDto): Promise<{
        message: string;
        updated: {
            id: any;
            pageID: any;
            priorityLevel: any;
            status: any;
            targetStockLevel: any;
        }[];
    }>;
    remove(id: number): Promise<{
        message: string;
    }>;
}
